/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.config.handler.abst;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.spi.json.GsonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.GsonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.config.job.ConfigurationHandlerWriteStorageJob;
import io.github.sakurawald.fuji.core.config.transformer.abst.ConfigurationTransformer;
import io.github.sakurawald.fuji.core.document.annotation.ForDeveloper;
import io.github.sakurawald.fuji.core.document.interfaces.SourceModuleGetter;
import io.github.sakurawald.fuji.core.event.impl.ServerLifecycleEvents;
import io.github.sakurawald.fuji.core.manager.Managers;
import io.github.sakurawald.fuji.core.manager.impl.module.ModuleManager;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobDataMap;

@ForDeveloper(value="1. Only use static inner class for a nested structure. (This is because a historical design problem in Java)\n2. If you want to register a new type for gson, just override the template method in module initializer.\n3. The type system of java is static, so you only need to give the object instance to gson.\n4. Define configuration handler using static variable, to ensure it's unique.\n")
public abstract class BaseConfigurationHandler<T>
implements SourceModuleGetter {
    public static final String CONFIG_JSON = "config.json";
    public static final Set<BaseConfigurationHandler<?>> REGISTERED_CONFIGURATION_HANDLERS = new HashSet();
    protected static Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().disableHtmlEscaping().serializeNulls().create();
    private static ParseContext JSON_PATH_PARSER = null;
    @NotNull
    protected final Path path;
    protected T model;
    private final List<ConfigurationTransformer> transformers = new ArrayList<ConfigurationTransformer>();

    public BaseConfigurationHandler(@NotNull Path path) {
        this.path = path;
    }

    public static ParseContext getJsonPathParser() {
        if (JSON_PATH_PARSER == null) {
            BaseConfigurationHandler.configureJsonPathLibrary();
            JSON_PATH_PARSER = JsonPath.using((Configuration)Configuration.defaultConfiguration());
        }
        return JSON_PATH_PARSER;
    }

    private static void configureJsonPathLibrary() {
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){

            public JsonProvider jsonProvider() {
                return new GsonJsonProvider(gson);
            }

            public MappingProvider mappingProvider() {
                return new GsonMappingProvider(gson);
            }

            public Set<Option> options() {
                return EnumSet.noneOf(Option.class);
            }
        });
    }

    public static void registerGsonTypeAdapter(Type type, Object typeAdapter) {
        gson = gson.newBuilder().registerTypeAdapter(type, typeAdapter).create();
    }

    public BaseConfigurationHandler<T> addTransformer(ConfigurationTransformer transformer) {
        this.transformers.add(transformer);
        return this;
    }

    protected abstract T getDefaultModel();

    public void readStorage() {
        block7: {
            try {
                this.transformers.forEach(it -> {
                    it.configure(this.path);
                    it.apply();
                });
                if (Files.notExists(this.path, new LinkOption[0])) {
                    this.writeStorage();
                    break block7;
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.path.toFile())));
                try {
                    T defaultModel = this.getDefaultModel();
                    this.model = gson.fromJson((Reader)reader, defaultModel.getClass());
                    this.writeStorage();
                }
                finally {
                    if (Collections.singletonList(reader).get(0) != null) {
                        ((Reader)reader).close();
                    }
                }
            }
            catch (Exception e) {
                LogUtil.error("Failed to read configuration file {} from storage.", this.path, e);
            }
        }
        REGISTERED_CONFIGURATION_HANDLERS.add(this);
    }

    public void beforeWriteStorage() {
    }

    public void writeStorage() {
        try {
            if (this.model == null) {
                this.model = this.getDefaultModel();
                LogUtil.debug("Write default configuration: {}", this.path.toFile().getAbsolutePath());
            }
            this.beforeWriteStorage();
            Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
            Files.writeString(this.path, (CharSequence)gson.toJson(this.model), new OpenOption[0]);
        }
        catch (Exception e) {
            LogUtil.error("Failed to write configuration file {} to disk.", this.path, e);
        }
    }

    public JsonElement convertModelToJsonTree() {
        return gson.toJsonTree(this.model());
    }

    private void scheduleWriteStorageJob(@NotNull String cron) {
        String jobName = this.path.toFile().getCanonicalPath();
        ConfigurationHandlerWriteStorageJob writeStorageJob = new ConfigurationHandlerWriteStorageJob(jobName, new JobDataMap(){
            {
                this.put(BaseConfigurationHandler.class.getName(), BaseConfigurationHandler.this);
            }
        }, () -> cron);
        Managers.getScheduleManager().scheduleJob(writeStorageJob);
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            LogUtil.debug("Write storage on server stopping: {}", this.path);
            this.writeStorage();
        });
    }

    public BaseConfigurationHandler<T> setAutoSaveEveryMinute() {
        this.scheduleWriteStorageJob("0 * * ? * * *");
        return this;
    }

    @NotNull
    public T model() {
        if (this.model == null) {
            this.readStorage();
        }
        if (this.model == null) {
            throw new IllegalStateException("The model of configuration file %s is null".formatted(this.path));
        }
        return this.model;
    }

    @Override
    public String getSourceModule() {
        return ModuleManager.computeJoinedModulePath(this.model().getClass().getName());
    }

    public static Gson getGson() {
        return gson;
    }

    @NotNull
    public Path getPath() {
        return this.path;
    }
}

