/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.config.transformer.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jayway.jsonpath.DocumentContext;
import io.github.sakurawald.fuji.core.auxiliary.JsonUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.transformer.abst.ConfigurationTransformer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;

public class FlattenTreeTransformer
extends ConfigurationTransformer {
    private final String subtreeIdentifier;
    private final String jsonPath;
    private final String topLevel;
    private final Function<String, Path> level2outPath;
    private boolean overrideTheOriginalFileWithSkeletonTree;

    public FlattenTreeTransformer(String jsonPath, String subtreeIdentifier, String topLevel, Function<String, Path> level2outPath) {
        this.subtreeIdentifier = subtreeIdentifier;
        this.jsonPath = jsonPath;
        this.topLevel = topLevel;
        this.level2outPath = level2outPath;
    }

    private void flatten(JsonObject parent, String level) {
        parent.keySet().stream().filter(key -> parent.get(key).isJsonObject() && parent.getAsJsonObject(key).has(this.subtreeIdentifier)).forEach(key -> {
            String nextLevel = CommandHelper.trimPathString(level + "." + key);
            this.flatten(parent.getAsJsonObject(key), nextLevel);
        });
        parent.remove(this.subtreeIdentifier);
        parent.keySet().stream().toList().stream().filter(key -> parent.get(key).isJsonObject() && JsonUtil.isEmpty(parent.getAsJsonObject(key))).forEach(arg_0 -> ((JsonObject)parent).remove(arg_0));
        Path currentTreeOutPath = this.level2outPath.apply(level);
        if (!JsonUtil.isEmpty(parent) && Files.notExists(currentTreeOutPath, new LinkOption[0])) {
            this.logConsole("flatten tree `{}` into the file `{}`", level, currentTreeOutPath);
            Files.createDirectories(currentTreeOutPath.getParent(), new FileAttribute[0]);
            String json = BaseConfigurationHandler.getGson().toJson((JsonElement)parent);
            Files.writeString(currentTreeOutPath, (CharSequence)json, new OpenOption[0]);
            this.overrideTheOriginalFileWithSkeletonTree = true;
        }
        parent.keySet().stream().toList().forEach(arg_0 -> ((JsonObject)parent).remove(arg_0));
    }

    private JsonObject makeSkeletonTree(JsonObject parent) {
        parent.keySet().stream().toList().stream().filter(key -> !key.equals(this.subtreeIdentifier)).forEach(key -> {
            if (parent.get(key).isJsonObject()) {
                this.makeSkeletonTree(parent.getAsJsonObject(key));
                if (JsonUtil.isEmpty(parent.getAsJsonObject(key))) {
                    parent.remove(key);
                }
            } else {
                parent.remove(key);
            }
        });
        return parent;
    }

    @Override
    public void apply() {
        DocumentContext context = this.makeDocumentContext();
        JsonObject root = (JsonObject)this.read(context, this.jsonPath);
        this.flatten(root, this.topLevel);
        if (this.overrideTheOriginalFileWithSkeletonTree) {
            JsonObject skeletonTree = (JsonObject)this.read(context, this.jsonPath);
            this.set(context, this.jsonPath, this.makeSkeletonTree(skeletonTree));
            this.writeStorage(context);
        }
    }
}

