/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.config.transformer.impl;

import io.github.sakurawald.fuji.core.config.transformer.abst.ConfigurationTransformer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class MoveFileTransformer
extends ConfigurationTransformer {
    private Path sourceFile;
    private Path destinationDirectory;

    @Override
    public void apply() {
        this.destinationDirectory = this.destinationDirectory.resolve(this.getPath().toFile().getName());
        if (Files.notExists(this.sourceFile, new LinkOption[0]) || Files.exists(this.destinationDirectory, new LinkOption[0])) {
            return;
        }
        Files.createDirectories(this.destinationDirectory.getParent(), new FileAttribute[0]);
        this.logConsole("move the file to {}", this.destinationDirectory);
        Files.move(this.sourceFile, this.destinationDirectory, new CopyOption[0]);
    }

    public MoveFileTransformer(Path sourceFile, Path destinationDirectory) {
        this.sourceFile = sourceFile;
        this.destinationDirectory = destinationDirectory;
    }
}

