/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.document.auxiliary;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.service.url_highlighter.UrlHighlighter;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentUtil {
    @NotNull
    public static String getDocString(@Nullable Object audience, long id) {
        if (id == 0L) {
            return "DUMMY-DOC-STRING";
        }
        String languageKey = "docstring." + id;
        String languageValue = TextHelper.Translator.getLanguageValueByKey(audience, languageKey);
        return languageValue;
    }

    @Nullable
    private static String getDocumentString(@Nullable Object audience, @Nullable Document annotation) {
        if (annotation == null) {
            return null;
        }
        if (TextHelper.Loader.shouldUseBuiltInDocStrings()) {
            return annotation.value();
        }
        return DocumentUtil.getDocString(audience, annotation.id());
    }

    @Nullable
    public static String getColorBoxString(@Nullable Object audience, @Nullable ColorBox annotation) {
        if (annotation == null) {
            return null;
        }
        if (TextHelper.Loader.shouldUseBuiltInDocStrings()) {
            return annotation.value();
        }
        return DocumentUtil.getDocString(audience, annotation.id());
    }

    @Nullable
    public static String getClassDocumentString(@Nullable Object audience, Class<?> clazz) {
        Document annotation = clazz.getAnnotation(Document.class);
        return DocumentUtil.getDocumentString(audience, annotation);
    }

    @Nullable
    public static String getFieldDocumentString(@Nullable Object audience, Field field) {
        Document annotation = field.getAnnotation(Document.class);
        return DocumentUtil.getDocumentString(audience, annotation);
    }

    public static String compileDocumentString(String documentString) {
        String decoratedDocumentString = Arrays.stream(documentString.split("\n")).map(line -> "<#FFA1F5>" + line).collect(Collectors.joining("\n"));
        decoratedDocumentString = UrlHighlighter.highlight(decoratedDocumentString);
        return decoratedDocumentString;
    }
}

