/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.document.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.processor.CommandAnnotationProcessor;
import io.github.sakurawald.fuji.core.command.structure.CommandDescriptor;
import io.github.sakurawald.fuji.core.gui.impl.gui.PagedGui;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandsInspectionGui
extends PagedGui<CommandDescriptor> {
    public CommandsInspectionGui(@Nullable SimpleGui parent, class_3222 player, @NotNull List<CommandDescriptor> entities, int pageIndex) {
        super(parent, player, TextHelper.getTextByKey(player, "fuji.inspect.fuji_commands.gui.title", new Object[0]), entities, pageIndex);
    }

    public static CommandsInspectionGui inspectAll(SimpleGui parent, class_3222 player) {
        List<CommandDescriptor> descriptors = CommandAnnotationProcessor.REGISTERED_COMMAND_DESCRIPTORS.stream().sorted(Comparator.comparing(CommandDescriptor::getCommandNodePath)).toList();
        return new CommandsInspectionGui(parent, player, descriptors, 0);
    }

    @Override
    protected PagedGui<CommandDescriptor> make(@Nullable SimpleGui parent, class_3222 player, class_2561 title, @NotNull List<CommandDescriptor> entities, int pageIndex) {
        return new CommandsInspectionGui(parent, player, entities, pageIndex);
    }

    private List<class_2561> computeDocumentsLore(CommandDescriptor entity) {
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        if (entity.document != null) {
            List<class_2561> methodDocumentTextList = TextHelper.getDocumentTextList(this.getPlayer(), entity.document);
            lore.addAll(methodDocumentTextList);
        }
        List<class_2561> parameterDocumentTextList = entity.arguments.stream().filter(it -> it.getDocument() != null).map(it -> {
            class_2561 documentText = TextHelper.getDocumentText(this.getPlayer(), "\u25c9 %s: %s".formatted(it.getArgumentName(), it.getDocument()));
            return documentText;
        }).toList();
        lore.addAll(parameterDocumentTextList);
        return lore;
    }

    @Override
    protected GuiElementInterface toGuiElement(CommandDescriptor entity) {
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        lore.addAll(List.of(TextHelper.getTextByKey(this.getPlayer(), "from_module", entity.getSourceModule()), TextHelper.getTextByKey(this.getPlayer(), "command.source.can_be_executed_by_console", entity.canBeExecutedByConsole()), TextHelper.getTextByKey(this.getPlayer(), "command.descriptor.type", entity.getClass().getSimpleName()), TextHelper.getTextByKey(this.getPlayer(), "command.requirement.level_permission", entity.getDefaultLevelPermission()), TextHelper.getTextByKey(this.getPlayer(), "command.requirement.string_permission", entity.getDefaultStringPermission())));
        List<class_2561> documents = this.computeDocumentsLore(entity);
        if (!documents.isEmpty()) {
            documents.add(0, (class_2561)class_2561.method_43473());
            lore.addAll(documents);
        }
        return new GuiElementBuilder().setName((class_2561)class_2561.method_43470((String)entity.getCommandSyntax())).setItem(class_1802.field_8468).setLore(lore).build();
    }
}

