/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.event.abst;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.document.annotation.ForDeveloper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

@ForDeveloper(value="The Event<T> describe a `generic event type`.\nThe `<T>` is used to describe a `specific event type`.\nAn `event type` is defined by its method signature.\nThe handlers holds the list of closure, to capture the needed surrounding variables.\nWhen an `specific event` is `fired`, we will iterate the handlers list, invoke the closures with method arguments.\nThe invoker factory says: give me the list of handlers, and give me the specific event type, I will make the closure invoker for you.\nEach time you register a new event callback (or we said the closure), you need to make a new invoker.\n\nThe invoker factory is a nested closure.\nThe first level captures the handlers variable instance from the specific event instance.\nThe second level captures the handlers argument from the first level, and iterates over it.\n\nIn most case, the `mixin` is just better than `event`:\n1. Mixin gives you fine-grained control on time sequence.\n2. Mixin gives you the proper way to handle `priority` and `cancelled event`. (Better injection point)\n3. Mixin has better performance.\n4. Mixin gives you the tool to make events.\n\nFor some convenient and stable event, you can use mixin to create abstraction for them.\nFor example, the `player joined event`...\n")
public class Event<T> {
    private final List<T> handlers = new ArrayList<T>();
    private final Function<List<T>, T> invokerFactory;
    private T invoker;

    public Event(Function<List<T>, T> invokerFactory) {
        this.invokerFactory = invokerFactory;
        this.makeNewInvoker();
    }

    private void makeNewInvoker() {
        this.invoker = this.invokerFactory.apply(this.handlers);
    }

    public void register(T eventCallback) {
        LogUtil.debug("Register event callback: event = {}, callback = {}", this.invoker.getClass().getName(), eventCallback.getClass().getName());
        this.handlers.add(eventCallback);
        this.makeNewInvoker();
    }

    public T invoker() {
        return this.invoker;
    }
}

