/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.gui.impl.gui;

import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.layered.BackendSimpleGui;
import eu.pb4.sgui.api.gui.layered.LayeredGui;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ItemStackHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.document.annotation.ForDeveloper;
import io.github.sakurawald.fuji.core.gui.impl.gui.InputSignGui;
import io.github.sakurawald.fuji.core.gui.impl.layer.SingleLineLayer;
import io.github.sakurawald.fuji.core.gui.structure.EntityToElementMapper;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PagedGui<T>
extends LayeredGui {
    @Nullable
    private final SimpleGui parent;
    private final List<T> entities;
    private final int pageIndex;
    private final class_2561 prefixTitle;
    @ForDeveloper(value="For Paged Gui, the last line is always used as footer.")
    private final SingleLineLayer footer = new SingleLineLayer();
    private final EntityToElementMapper<T> entityToElementMapper = new EntityToElementMapper();
    private boolean openParentGuiWhenClose = true;

    public PagedGui(@Nullable SimpleGui parent, @NotNull class_3222 player, @NotNull class_2561 prefixTitle, @NotNull List<T> entities, int pageIndex) {
        super(class_3917.field_17327, player, false);
        this.parent = parent;
        this.prefixTitle = prefixTitle;
        this.pageIndex = pageIndex;
        this.entities = entities;
    }

    public boolean open() {
        this.drawPagedGui();
        return super.open();
    }

    protected abstract PagedGui<T> make(@Nullable SimpleGui var1, class_3222 var2, class_2561 var3, @NotNull List<T> var4, int var5);

    private void drawNavigator(int pageIndex) {
        SingleLineLayer pageLayer = new SingleLineLayer(GuiHelper.makeSlotPlaceholderButton());
        pageLayer.setSlot(0, GuiHelper.makePreviousPageButton(this.getPlayer()).setCallback(() -> this.tryChangePage(pageIndex - 1)));
        pageLayer.setSlot(this.getWidth() - 1, GuiHelper.makeNextPageButton(this.getPlayer()).setCallback(() -> this.tryChangePage(pageIndex + 1)));
        pageLayer.setSlot(this.getWidth() - 2, GuiHelper.makeSearchButton(this.getPlayer()).setCallback(() -> new InputSignGui(this.getPlayer(), null){

            public void onClose() {
                String keyword = this.joinStrings();
                PagedGui.this.linkCurrentGuiAndSearch(keyword).open();
            }
        }.open()));
        this.addLayer(pageLayer, 0, this.getHeight() - 1);
    }

    protected void drawPagedGui() {
        this.drawTitle();
        this.drawEntitiesOnThisPage(this.entities);
        this.drawNavigator(this.pageIndex);
        this.addLayer(this.footer, 0, this.getHeight() - 1);
    }

    private void drawEntitiesOnThisPage(@NotNull List<T> entities) {
        int slotIndex = 0;
        for (int i = this.getEntityBeginIndex(this.pageIndex); i < this.getEntityEndIndex(this.pageIndex); ++i) {
            T entity = entities.get(i);
            this.setSlot(slotIndex++, this.makeGuiElementAndBindIt(entity));
        }
    }

    private void tryChangePage(int newPageIndex) {
        int entityBeginIndex = this.getEntityBeginIndex(newPageIndex);
        if (entityBeginIndex < 0 || entityBeginIndex >= this.getEntitySize()) {
            return;
        }
        this.make(this.parent, this.getPlayer(), this.prefixTitle, this.entities, newPageIndex).open();
    }

    @NotNull
    public PagedGui<T> linkCurrentGuiAndSearch(String keywords) {
        class_2561 resultTitle = TextHelper.getTextByKey(this.getPlayer(), "gui.search.title", keywords);
        List<T> resultEntities = this.filterEntities(keywords);
        BackendSimpleGui trueParent = this.gui;
        if (resultEntities.size() == this.getEntitySize()) {
            trueParent = this.parent;
        }
        return this.make((SimpleGui)trueParent, this.getPlayer(), resultTitle, resultEntities, 0);
    }

    @NotNull
    public PagedGui<T> skipCurrentGuiAndSearch(Predicate<T> predicate) {
        class_2561 resultTitle = TextHelper.getTextByKey(this.getPlayer(), "gui.search.title", "YOU SHOULD NOT SEE THIS");
        List resultEntities = this.entities.stream().filter(predicate).toList();
        return this.make(this.parent, this.getPlayer(), resultTitle, resultEntities, 0);
    }

    protected abstract GuiElementInterface toGuiElement(T var1);

    @NotNull
    private GuiElementInterface makeGuiElementAndBindIt(T entity) {
        GuiElementInterface element = this.toGuiElement(entity);
        this.entityToElementMapper.setBinding(entity, element);
        return element;
    }

    protected boolean filterEntity(T entity, String keyword) {
        return false;
    }

    private boolean combinedFilterEntity(T entity, String keyword) {
        class_1799 itemStack;
        GuiElementInterface element = this.entityToElementMapper.getBinding(entity);
        if (element == null) {
            element = this.makeGuiElementAndBindIt(entity);
        }
        if (ItemStackHelper.filterItemStack(itemStack = element.getItemStack(), keyword)) {
            return true;
        }
        return this.filterEntity(entity, keyword);
    }

    private List<T> filterEntities(String keyword) {
        return this.entities.stream().filter(entity -> this.combinedFilterEntity(entity, keyword)).collect(Collectors.toList());
    }

    public List<GuiElementInterface> toGuiElements() {
        return this.entities.stream().map(this::makeGuiElementAndBindIt).toList();
    }

    private void drawTitle() {
        class_5250 formatted = this.prefixTitle.method_27661().method_10852(TextHelper.getTextByKey(this.getPlayer(), "gui.page.title", this.getCurrentPageNumber(), this.getMaxPageNumber()));
        this.setTitle((class_2561)formatted);
    }

    private int getEntitySize() {
        return this.entities.size();
    }

    private int getCurrentPageNumber() {
        return this.pageIndex + 1;
    }

    private int getMaxPageNumber() {
        if (this.getEntitySize() == 0) {
            return 1;
        }
        int a = this.getEntitySize();
        int b = this.getEntityPageSize();
        int bias = 0;
        if (a % b != 0) {
            bias = 1;
        }
        return a / b + bias;
    }

    private int getEntityPageSize() {
        return this.getWidth() * this.getHeight() - 9;
    }

    private int getEntityBeginIndex(int pageIndex) {
        return this.getEntityPageSize() * pageIndex;
    }

    private int getEntityEndIndex(int pageIndex) {
        return Math.min(this.getEntityBeginIndex(pageIndex + 1), this.getEntitySize());
    }

    public void onClose() {
        if (this.openParentGuiWhenClose && this.parent != null) {
            this.parent.open();
        }
    }

    public void closeWithoutOpenParentGui() {
        this.openParentGuiWhenClose = false;
        this.close();
    }

    @NotNull
    public SimpleGui getBackendGui() {
        return this.gui;
    }

    @Nullable
    public SimpleGui getParent() {
        return this.parent;
    }

    public List<T> getEntities() {
        return this.entities;
    }

    public SingleLineLayer getFooter() {
        return this.footer;
    }
}

