/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.job.abst;

import io.github.sakurawald.fuji.core.auxiliary.RandomUtil;
import org.jetbrains.annotations.Nullable;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Trigger;
import org.quartz.TriggerKey;

public abstract class BaseJob
implements Job {
    protected String jobGroup;
    protected String jobName;
    protected JobDetail jobDetail;
    protected TriggerKey triggerKey;
    protected boolean rescheduleAble;

    public BaseJob(@Nullable String jobGroup, @Nullable String jobName, @Nullable JobDataMap jobDataMap, boolean rescheduleAble) {
        if (jobGroup == null) {
            jobGroup = this.getClass().getName();
        }
        if (jobName == null) {
            jobName = RandomUtil.randomUUID();
        }
        if (jobDataMap == null) {
            jobDataMap = new JobDataMap();
        }
        this.jobGroup = jobGroup;
        this.jobName = jobName;
        this.jobDetail = JobBuilder.newJob(this.getClass()).withIdentity(jobName, jobGroup).usingJobData(jobDataMap).build();
        this.triggerKey = new TriggerKey(jobName, jobGroup);
        this.rescheduleAble = rescheduleAble;
    }

    public abstract Trigger makeTrigger();

    public String toString() {
        return "{jobGroup = %s, jobName = %s}".formatted(this.jobGroup, this.jobName);
    }

    public BaseJob() {
    }

    public String getJobGroup() {
        return this.jobGroup;
    }

    public String getJobName() {
        return this.jobName;
    }

    public JobDetail getJobDetail() {
        return this.jobDetail;
    }

    public TriggerKey getTriggerKey() {
        return this.triggerKey;
    }

    public boolean isRescheduleAble() {
        return this.rescheduleAble;
    }
}

