/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.job.impl;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.job.abst.FixedIntervalJob;
import io.github.sakurawald.fuji.core.manager.Managers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public class PlaySoundJob
extends FixedIntervalJob {
    public PlaySoundJob(JobDataMap jobDataMap, int intervalMs, int repeatCount) {
        super(null, null, jobDataMap, intervalMs, repeatCount);
    }

    public static void scheduleJob(final PlaySoundJobSetup setup, final List<class_3222> mentionedPlayers) {
        int intervalMs = setup.interval_ms;
        int repeatCount = setup.repeat_count;
        PlaySoundJob mentionPlayersJob = new PlaySoundJob(new JobDataMap(){
            {
                this.put(List.class.getName(), mentionedPlayers);
                this.put(PlaySoundJobSetup.class.getName(), setup);
            }
        }, intervalMs, repeatCount);
        Managers.getScheduleManager().scheduleJob(mentionPlayersJob);
    }

    public static void scheduleJob(PlaySoundJobSetup setup, class_3222 serverPlayer) {
        PlaySoundJob.scheduleJob(setup, new ArrayList<class_3222>(Collections.singletonList(serverPlayer)));
    }

    public void execute(@NotNull JobExecutionContext context) {
        List players = (List)context.getJobDetail().getJobDataMap().get((Object)List.class.getName());
        PlaySoundJobSetup setup = (PlaySoundJobSetup)context.getJobDetail().getJobDataMap().get((Object)PlaySoundJobSetup.class.getName());
        players.stream().filter(Objects::nonNull).forEach(player -> ServerHelper.getServer().method_40000(() -> {
            class_3414 soundEvent = class_3414.method_47908((class_2960)RegistryHelper.makeIdentifier(setup.sound));
            class_3419 soundCategory = class_3419.field_15245;
            PlayerHelper.playSound(player, soundEvent, soundCategory, setup.volume, setup.pitch);
        }));
    }

    public PlaySoundJob() {
    }

    public static class PlaySoundJobSetup {
        @Document(id=1751823822772L, value="The `sound` identifier.")
        @NotNull
        public String sound = "entity.experience_orb.pickup";
        public float volume = 100.0f;
        public float pitch = 1.0f;
        @Document(id=1751823830414L, value="The times to play this sound.")
        public int repeat_count = 3;
        @Document(id=1751823834755L, value="The interval between each sound play.")
        public int interval_ms = 1000;
    }
}

