/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.manager.impl.bossbar;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.event.impl.PlayerEvents;
import io.github.sakurawald.fuji.core.event.impl.ServerTickEvents;
import io.github.sakurawald.fuji.core.manager.abst.BaseManager;
import io.github.sakurawald.fuji.core.manager.impl.bossbar.BossBarTicket;
import io.github.sakurawald.fuji.core.manager.impl.bossbar.structure.InterruptibleTicket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class BossBarManager
extends BaseManager {
    private final List<BossBarTicket> tickets = new CopyOnWriteArrayList<BossBarTicket>();
    private final List<BossBarTicket> addedTickets = new CopyOnWriteArrayList<BossBarTicket>();

    @Override
    public void onInitialize() {
        ServerTickEvents.START_SERVER_TICK.register(this::onServerTick);
        PlayerEvents.ON_DAMAGED.register((player, damageSource, amount) -> this.tickets.stream().filter(it -> {
            InterruptibleTicket interruptibleTicket;
            return it instanceof InterruptibleTicket && (interruptibleTicket = (InterruptibleTicket)it).getInterruptible().isEnable() && interruptibleTicket.getInterruptible().isInterruptOnDamaged() && PlayerHelper.isRealPlayer(player) && it.getPlayers().stream().anyMatch(p -> p.equals((Object)player));
        }).forEach(it -> it.setAborted(true)));
    }

    public Collection<BossBarTicket> getTickets() {
        return Collections.unmodifiableCollection(this.tickets);
    }

    public void addTicket(BossBarTicket ticket) {
        this.addedTickets.add(ticket);
    }

    private void abortTicket(@NotNull BossBarTicket ticket) {
        ticket.clearPlayers();
        this.tickets.remove(ticket);
    }

    private void onServerTick(MinecraftServer server) {
        this.tickets.addAll(this.addedTickets);
        this.addedTickets.clear();
        if (this.tickets.isEmpty()) {
            return;
        }
        ArrayList<BossBarTicket> abortedTickets = new ArrayList<BossBarTicket>();
        ArrayList<BossBarTicket> completedTickets = new ArrayList<BossBarTicket>();
        for (BossBarTicket ticket : this.tickets) {
            if (ticket.isAborted()) {
                abortedTickets.add(ticket);
                continue;
            }
            if (!ticket.preProgressChange()) {
                ticket.setAborted(true);
                continue;
            }
            ticket.getBossBar().method_14091(true);
            for (class_3222 player : ticket.getPlayers()) {
                if (!player.method_14239()) continue;
                ticket.onPlayerDisconnected(player);
                ticket.removePlayer(player);
            }
            try {
                ticket.step();
            }
            catch (Exception e) {
                ticket.setAborted(true);
                return;
            }
            if (!ticket.postProgressChange()) {
                ticket.setAborted(true);
                continue;
            }
            if (!ticket.isCompleted()) continue;
            ticket.setAborted(true);
            completedTickets.add(ticket);
        }
        completedTickets.forEach(BossBarTicket::onComplete);
        abortedTickets.forEach(this::abortTicket);
    }
}

