/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.manager.impl.bossbar;

import io.github.sakurawald.fuji.core.command.argument.wrapper.StepType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public abstract class BossBarTicket {
    private final float totalTicks;
    private final float stepTicksPerTick;
    private final class_3213 bossBar;
    private final StepType stepType;
    private boolean aborted;

    public BossBarTicket(class_3213 bossBar, int totalMs, StepType stepType, @NotNull List<class_3222> players) {
        this.bossBar = bossBar;
        this.totalTicks = 20.0f * ((float)totalMs / 1000.0f);
        this.stepType = stepType;
        this.bossBar.method_5408(this.computeInitialProgress());
        this.stepTicksPerTick = this.computeStepTicksPerTick();
        players.forEach(this::addPlayer);
        this.bossBar.method_14091(false);
    }

    public BossBarTicket(class_3213 bossBar, int totalMs, @NotNull List<class_3222> players) {
        this(bossBar, totalMs, StepType.FORWARD, players);
    }

    private float computeInitialProgress() {
        return this.stepType == StepType.FORWARD ? 0.0f : 1.0f;
    }

    private float computeStepTicksPerTick() {
        float abs = 1.0f / this.totalTicks;
        return this.stepType == StepType.FORWARD ? abs : -abs;
    }

    @NotNull
    public Collection<class_3222> getPlayers() {
        return Collections.unmodifiableCollection(this.bossBar.method_14092());
    }

    public void step() {
        if (this.stepType == StepType.FORWARD) {
            this.progress(Math.min(1.0f, this.progress() + this.stepTicksPerTick));
        } else {
            this.progress(Math.max(0.0f, this.progress() + this.stepTicksPerTick));
        }
    }

    public boolean isCompleted() {
        if (this.stepType == StepType.FORWARD) {
            return Float.compare(this.progress(), 1.0f) == 0;
        }
        return Float.compare(this.progress(), 0.0f) == 0;
    }

    public float progress() {
        return this.bossBar.method_5412();
    }

    public void progress(float progress) {
        this.bossBar.method_5408(progress);
    }

    public void addPlayer(@NotNull class_3222 player) {
        this.bossBar.method_14088(player);
    }

    public void removePlayer(@NotNull class_3222 player) {
        this.bossBar.method_14089(player);
    }

    public void clearPlayers() {
        this.bossBar.method_14091(false);
        this.bossBar.method_14094();
    }

    protected void onPlayerDisconnected(class_3222 player) {
    }

    protected boolean preProgressChange() {
        return true;
    }

    protected boolean postProgressChange() {
        return true;
    }

    protected abstract void onComplete();

    public float getTotalTicks() {
        return this.totalTicks;
    }

    public float getStepTicksPerTick() {
        return this.stepTicksPerTick;
    }

    public class_3213 getBossBar() {
        return this.bossBar;
    }

    public StepType getStepType() {
        return this.stepType;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }
}

