/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.manager.impl.callback;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.RandomUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.event.impl.CommandEvents;
import io.github.sakurawald.fuji.core.manager.abst.BaseManager;
import io.github.sakurawald.fuji.core.manager.impl.callback.structure.TTLMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_3222;

public class CallbackManager
extends BaseManager {
    private static final String COMMAND_CALLBACK_LITERAL = "command-callback";
    private final TTLMap<String, Consumer<class_3222>> uuid2consumer = new TTLMap();

    @Override
    public void onInitialize() {
        this.registerUserCommand();
    }

    private void registerUserCommand() {
        CommandEvents.REGISTRATION.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND_CALLBACK_LITERAL).then(class_2170.method_9244((String)"uuid", (ArgumentType)StringArgumentType.greedyString()).executes(this::$executeCallbackCommand))));
    }

    private int $executeCallbackCommand(CommandContext<class_2168> ctx) {
        return CommandHelper.Pattern.playerOnlyCommand((class_2168)ctx.getSource(), player -> {
            String uuid = StringArgumentType.getString((CommandContext)ctx, (String)"uuid");
            this.executeCallbackCommand(uuid, (class_3222)player);
            return 1;
        });
    }

    private void executeCallbackCommand(String uuid, class_3222 player) {
        Consumer<class_3222> consumer = this.uuid2consumer.get(uuid);
        if (consumer == null) {
            TextHelper.sendTextByKey(player, "callback.invalid", new Object[0]);
            return;
        }
        consumer.accept(player);
    }

    private String makeCallbackCommand(String uuid, Consumer<class_3222> callback, long ttl, TimeUnit timeUnit) {
        LogUtil.debug("Make callback command: uuid = {}", uuid);
        this.uuid2consumer.put(uuid, callback, ttl, timeUnit);
        return "/command-callback " + uuid;
    }

    public String makeCallbackCommand(Consumer<class_3222> callback, long ttl, TimeUnit timeUnit) {
        return this.makeCallbackCommand(RandomUtil.randomUUID(), callback, ttl, timeUnit);
    }

    private class_2558 makeCallbackEvent(String uuid, Consumer<class_3222> callback, long ttl, TimeUnit timeUnit) {
        String commandString = this.makeCallbackCommand(uuid, callback, ttl, timeUnit);
        return TextHelper.Events.ClickEvent.makeRunCommandAction(commandString);
    }

    public class_2558 makeCallbackEvent(Consumer<class_3222> callback, long ttl, TimeUnit timeUnit) {
        return this.makeCallbackEvent(RandomUtil.randomUUID(), callback, ttl, timeUnit);
    }
}

