/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.manager.impl.callback.structure;

import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.job.abst.CronJob;
import io.github.sakurawald.fuji.core.manager.Managers;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public class TTLMap<K, V> {
    private final ConcurrentMap<K, ExpiringValue<V>> backendMap = new ConcurrentHashMap<K, ExpiringValue<V>>();

    public TTLMap() {
        CleanTTLMapJob cleanTTLMapJob = new CleanTTLMapJob(new JobDataMap(){
            {
                this.put(TTLMap.class.getName(), TTLMap.this);
            }
        }, () -> "0 * * ? * * *");
        Managers.getScheduleManager().scheduleJob(cleanTTLMapJob);
    }

    public void put(K key, V value, long ttl, TimeUnit unit) {
        long expiryTime = System.currentTimeMillis() + unit.toMillis(ttl);
        this.backendMap.put(key, new ExpiringValue<V>(value, expiryTime));
    }

    public V get(K key) {
        ExpiringValue expiringValue = (ExpiringValue)this.backendMap.get(key);
        if (expiringValue != null && System.currentTimeMillis() < expiringValue.expiryTime) {
            return expiringValue.value;
        }
        this.backendMap.remove(key);
        return null;
    }

    public void remove(K key) {
        this.backendMap.remove(key);
    }

    private void cleanUp() {
        long currentTime = System.currentTimeMillis();
        for (Map.Entry entry : this.backendMap.entrySet()) {
            if (currentTime <= ((ExpiringValue)entry.getValue()).expiryTime) continue;
            this.backendMap.remove(entry.getKey());
        }
    }

    @Document(id=1751823961060L, value="This `job` is used to clean up the `TTL Map` data structure, and remove `expired entries`.\n")
    public static class CleanTTLMapJob
    extends CronJob {
        public CleanTTLMapJob(JobDataMap jobDataMap, Supplier<String> cronSupplier) {
            super(jobDataMap, cronSupplier);
        }

        public void execute(JobExecutionContext context) {
            TTLMap instance = (TTLMap)context.getJobDetail().getJobDataMap().get((Object)TTLMap.class.getName());
            instance.cleanUp();
        }

        public CleanTTLMapJob() {
        }
    }

    private record ExpiringValue<V>(V value, long expiryTime) {
    }
}

