/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.manager.impl.module;

import com.google.gson.JsonObject;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.fuji.core.config.Configs;
import io.github.sakurawald.fuji.core.manager.Managers;
import io.github.sakurawald.fuji.core.manager.abst.BaseManager;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.mixin.GlobalMixinConfigPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.service.MixinService;

public class ModuleManager
extends BaseManager {
    public static final String ENABLE_SUPPLIER_KEY = "enable";
    public static final String CORE_MODULE_PATH = "core";
    private static final Set<String> MODULE_PATHS = new HashSet<String>(ReflectionUtil.getCompileTimeGraph("module-graph.txt"));
    public static final Map<List<String>, Boolean> MODULE_ENABLE_STATUS = new HashMap<List<String>, Boolean>();
    private static final Map<String, String> CLASS_NAME_2_MODULE_PATH_STRING = new HashMap<String, String>();
    public static final Map<Class<? extends ModuleInitializer>, ModuleInitializer> MODULE_INITIALIZER_BY_CLASS = new HashMap<Class<? extends ModuleInitializer>, ModuleInitializer>();
    public static final Map<String, Class<? extends ModuleInitializer>> MODULE_INITIALIZER_CLASS_BY_MODULE_PATH_STRING = new HashMap<String, Class<? extends ModuleInitializer>>();

    public static String computeJoinedModulePath(@NotNull String className) {
        String modulePathString = CLASS_NAME_2_MODULE_PATH_STRING.get(className);
        if (modulePathString != null) {
            return modulePathString;
        }
        String result = ModuleManager.joinModulePath(ModuleManager.computeSplitModulePath(className));
        CLASS_NAME_2_MODULE_PATH_STRING.put(className, result);
        return result;
    }

    @NotNull
    public static List<String> computeSplitModulePath(@NotNull String className) {
        if (MODULE_PATHS.isEmpty()) {
            LogUtil.warn("This is the first time we generating the module graph file, we just ", new Object[0]);
        }
        int left = -1;
        List<Class<GlobalMixinConfigPlugin>> modulePackagePrefixes = List.of(ModuleInitializer.class, GlobalMixinConfigPlugin.class);
        for (Class<GlobalMixinConfigPlugin> modulePackagePrefix : modulePackagePrefixes) {
            String prefix = modulePackagePrefix.getPackageName();
            if (!className.startsWith(prefix) || className.equals(modulePackagePrefix.getName())) continue;
            left = prefix.length() + 1;
            break;
        }
        if (left == -1) {
            return List.of(CORE_MODULE_PATH);
        }
        String str = className.substring(left);
        int right = str.lastIndexOf(".");
        ArrayList<String> modulePath = new ArrayList<String>(List.of((str = str.substring(0, right)).split("\\.")));
        if (((String)modulePath.get(0)).equals(CORE_MODULE_PATH)) {
            return List.of(CORE_MODULE_PATH);
        }
        String modulePathString = String.join((CharSequence)".", modulePath);
        while (!MODULE_PATHS.contains(modulePathString)) {
            if (modulePath.isEmpty()) {
                throw new RuntimeException("Can't find the module enable-supplier in `config.json` for class name %s. Did you forget to add the enable-supplier key in ConfigModel ?".formatted(className));
            }
            modulePath.remove(modulePath.size() - 1);
            modulePathString = String.join((CharSequence)".", modulePath);
        }
        return modulePath;
    }

    public static String joinModulePath(List<String> modulePath) {
        return String.join((CharSequence)".", modulePath);
    }

    public static List<String> splitModulePath(String modulePath) {
        return Arrays.stream(modulePath.split("\\.")).toList();
    }

    @Override
    public void onInitialize() {
        this.invokeModuleInitializers();
    }

    private void invokeModuleInitializers() {
        ReflectionUtil.getCompileTimeGraph("module-initializer-graph.txt").forEach(className -> {
            try {
                Class clazz = MixinService.getService().getClassProvider().findClass(className, false);
                String modulePathString = ModuleManager.computeJoinedModulePath(className);
                MODULE_INITIALIZER_CLASS_BY_MODULE_PATH_STRING.put(modulePathString, clazz);
                boolean enable = Managers.getModuleManager().shouldWeLoadThis((String)className);
                if (!enable) {
                    return;
                }
                this.initializeModuleInitializer(clazz);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public <T extends ModuleInitializer> void initializeModuleInitializer(@NotNull Class<T> clazz) {
        String className;
        if (!MODULE_INITIALIZER_BY_CLASS.containsKey(clazz) && this.shouldWeLoadThis(className = clazz.getName())) {
            try {
                ModuleInitializer moduleInitializer = (ModuleInitializer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                moduleInitializer.doInitialize();
                MODULE_INITIALIZER_BY_CLASS.put(clazz, moduleInitializer);
            }
            catch (Exception e) {
                LogUtil.warn("Sorry, failed to initialize the module `{}`. I will crash the server now, to minimize losses.", className);
                throw new RuntimeException("Crashed by fuji mod by design, see above.", e);
            }
        }
    }

    public void reloadModuleInitializers() {
        MODULE_INITIALIZER_BY_CLASS.values().forEach(initializer -> {
            try {
                initializer.doReload();
            }
            catch (Exception originalException) {
                LogUtil.error("Failed to reload the module: initializer = {}", initializer.getClass().getName(), originalException);
                throw originalException;
            }
        });
    }

    public boolean shouldWeLoadThis(String className) {
        return this.shouldWeLoadThis(ModuleManager.computeSplitModulePath(className));
    }

    private boolean shouldWeLoadThis(@NotNull List<String> modulePath) {
        if (Configs.MAIN_CONTROL_CONFIG.model().core.debug.disable_all_modules) {
            return false;
        }
        if (modulePath.get(0).equals(CORE_MODULE_PATH)) {
            return true;
        }
        if (MODULE_ENABLE_STATUS.containsKey(modulePath)) {
            return MODULE_ENABLE_STATUS.get(modulePath);
        }
        boolean enable = true;
        JsonObject parent = Configs.MAIN_CONTROL_CONFIG.convertModelToJsonTree().getAsJsonObject().get("modules").getAsJsonObject();
        for (String node : modulePath) {
            if ((parent = parent.getAsJsonObject(node)) == null || !parent.has(ENABLE_SUPPLIER_KEY)) {
                throw new RuntimeException("missing `enable supplier` key for dir name list `%s`".formatted(modulePath));
            }
            if (parent.getAsJsonPrimitive(ENABLE_SUPPLIER_KEY).getAsBoolean()) continue;
            enable = false;
            break;
        }
        if (!this.isRequiredModsInstalled(modulePath)) {
            LogUtil.debug("Refuse to enable module {} (reason: the required dependency mod for this module isn't installed, please read the official wiki!)", modulePath);
            enable = false;
        }
        MODULE_ENABLE_STATUS.put(modulePath, enable);
        return enable;
    }

    private boolean isRequiredModsInstalled(@NotNull List<String> modulePath) {
        if (modulePath.contains("carpet")) {
            return FabricLoader.getInstance().isModLoaded("carpet");
        }
        return true;
    }
}

