/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.service.gameprofile_fetcher;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.github.sakurawald.fuji.core.auxiliary.IOUtil;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import java.io.IOException;
import java.util.UUID;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class MojangProfileFetcher {
    private static final String API_SERVER = "https://api.mojang.com/users/profiles/minecraft/";
    private static final String SESSION_SERVER = "https://sessionserver.mojang.com/session/minecraft/profile/";
    private static final Pattern UUID_CONVERTER_PATTERN = Pattern.compile("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)");

    public static GameProfile makeOnlineGameProfile(String playerName) {
        return new GameProfile(MojangProfileFetcher.fetchOnlineUUID(playerName), playerName);
    }

    @Nullable
    public static UUID fetchOnlineUUID(String playerName) {
        String rawUUID;
        try {
            rawUUID = JsonParser.parseString((String)IOUtil.requestGet(API_SERVER + playerName)).getAsJsonObject().get("id").getAsString();
        }
        catch (IOException e) {
            LogUtil.debug("Failed to fetch online uuid from mojang server for {}", playerName);
            return null;
        }
        return UUID.fromString(UUID_CONVERTER_PATTERN.matcher(rawUUID).replaceFirst("$1-$2-$3-$4-$5"));
    }

    @Nullable
    public static Property fetchOnlineSkin(String playerName) {
        try {
            UUID uuid = MojangProfileFetcher.fetchOnlineUUID(playerName);
            String json = IOUtil.requestGet(SESSION_SERVER + String.valueOf(uuid) + "?unsigned=false");
            JsonObject texture = JsonParser.parseString((String)json).getAsJsonObject().getAsJsonArray("properties").get(0).getAsJsonObject();
            return new Property("textures", texture.get("value").getAsString(), texture.get("signature").getAsString());
        }
        catch (Exception e) {
            LogUtil.debug("Failed to fetch online skin from mojang server for {}", playerName);
            return null;
        }
    }
}

