/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.service.style_striper;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import io.github.sakurawald.fuji.core.document.annotation.DocStringProvider;
import io.github.sakurawald.fuji.core.document.descriptor.PermissionDescriptor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1657;

public class StyleStriper {
    private static final Pattern TAG_RESOLVER = Pattern.compile("<([^>]+)>");
    private static final Map<String, PermissionDescriptor> CREATED_STYLE_TYPES = new HashMap<String, PermissionDescriptor>();

    public static String stripe(class_1657 player, String type, String input) {
        for (String tag : StyleStriper.resolveTags(input)) {
            String tagType = StyleStriper.extractTagType(tag);
            if (StyleStriper.canUseThisTag(player, type, tagType)) continue;
            input = input.replace(tag, "");
        }
        return input;
    }

    private static String extractTagType(String tag) {
        int colonIndex;
        if ((tag = tag.trim()).startsWith("/")) {
            tag = tag.substring(1);
        }
        if (tag.endsWith("\\")) {
            tag = tag.substring(0, tag.length() - 1);
        }
        if ((colonIndex = tag.indexOf(58)) != -1) {
            return tag.substring(0, colonIndex);
        }
        int blankIndex = tag.indexOf(32);
        if (blankIndex != -1) {
            return tag.substring(0, blankIndex);
        }
        return tag;
    }

    private static Set<String> resolveTags(String string) {
        HashSet<String> tags = new HashSet<String>();
        Matcher matcher = TAG_RESOLVER.matcher(string);
        while (matcher.find()) {
            String tag = matcher.group(1);
            tags.add(tag);
        }
        LogUtil.debug("Resolve style tags: {}", tags);
        return tags;
    }

    @DocStringProvider(id=1751999453562L, value="")
    private static PermissionDescriptor getOrCreatePermissionDescriptorForStyleType(String styleType) {
        return CREATED_STYLE_TYPES.computeIfAbsent(styleType, it -> {
            String pattern = "fuji.style.%s.<style-tag>";
            pattern = pattern.formatted(styleType);
            String document = "The permission used for `style tags striper`.\nA player requires the `corresponding permission` to use that `style tag` in `%s` style type.\n".formatted(styleType);
            return new PermissionDescriptor(pattern, 1751999453562L);
        });
    }

    private static boolean canUseThisTag(class_1657 player, String type, String tag) {
        PermissionDescriptor permission = StyleStriper.getOrCreatePermissionDescriptorForStyleType(type);
        return LuckpermsHelper.hasPermission(player.method_5667(), permission, type, tag);
    }
}

