/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.structure;

import java.util.HashMap;
import java.util.Map;

public class Cooldown<T> {
    private final Map<T, Long> timestamp = new HashMap<T, Long>();

    public long getCooldown(T key, Long cooldown) {
        long lastUpdateTimeMs = this.timestamp.computeIfAbsent(key, k -> 0L);
        long currentTimeMs = System.currentTimeMillis();
        long cooldownMS = cooldown;
        return cooldownMS - (currentTimeMs - lastUpdateTimeMs);
    }

    public long tryUse(T key, Long cooldown) {
        long leftTime = this.getCooldown(key, cooldown);
        if (leftTime < 0L) {
            this.timestamp.put(key, System.currentTimeMillis());
        }
        return leftTime;
    }

    public Map<T, Long> getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cooldown)) {
            return false;
        }
        Cooldown other = (Cooldown)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<T, Long> this$timestamp = this.getTimestamp();
        Map<T, Long> other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Cooldown;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<T, Long> $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        return result;
    }

    public String toString() {
        return "Cooldown(timestamp=" + String.valueOf(this.getTimestamp()) + ")";
    }
}

