/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.structure;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import io.github.sakurawald.fuji.core.document.annotation.DocStringProvider;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.descriptor.PermissionDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import org.jetbrains.annotations.NotNull;

public class Tag {
    private static final Map<String, PermissionDescriptor> CREATED_TAG_PERMISSIONS = new HashMap<String, PermissionDescriptor>();
    @Document(id=1751823907693L, value="Attached `tag name` list for this `configuration section`.\n")
    public List<String> tags = new ArrayList<String>(){
        {
            this.add("default-tag-name");
        }
    };

    @DocStringProvider(id=1751998842298L, value="Having this `permission`, means having the specified `tag name` for specified `tag type`.\n")
    private static PermissionDescriptor getOrCreateTagPermission(String tagType) {
        return CREATED_TAG_PERMISSIONS.computeIfAbsent(tagType, k -> {
            String pattern = "fuji.%s.<tag-name>";
            pattern = pattern.formatted(tagType);
            return new PermissionDescriptor(pattern, 1751998842298L);
        });
    }

    public static boolean hasAnyTagPermission(@NotNull class_1657 player, String tagType, List<String> tagNames) {
        boolean result = false;
        for (String tag : tagNames) {
            PermissionDescriptor permission = Tag.getOrCreateTagPermission(tagType);
            if (!LuckpermsHelper.hasPermission(player.method_5667(), permission, tagType, tag)) continue;
            result = true;
            break;
        }
        return result;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tag)) {
            return false;
        }
        Tag other = (Tag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Tag;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "Tag(tags=" + String.valueOf(this.getTags()) + ")";
    }
}

