/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.structure;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import net.minecraft.class_3218;

public class TeleportSetup {
    @Document(id=1751823841574L, value="The `target dimension` of this setup.\n")
    private final String dimension;
    @Document(id=1751823848934L, value="The `center x` used as the `origin` for `rtp`.\n")
    private final int centerX;
    @Document(id=1751823859284L, value="See `centerX`.\n")
    private final int centerZ;
    @Document(id=1751823867105L, value="Use `circle` shape or `rectangle` shape for `rtp`?\n")
    private final boolean circle;
    @Document(id=1751823872674L, value="The `relative x/z distance` is ranged `(minRange, maxRange]`.\n")
    private final int minRange;
    @Document(id=1751823877287L, value="See `minRange`.\n")
    private final int maxRange;
    @Document(id=1751823883726L, value="The `relative y distance` is ranged `(minY, maxY]`.\n")
    private final int minY;
    @Document(id=1751823889193L, value="See `minY`.\n")
    private final int maxY;
    @Document(id=1751823896496L, value="Max try times before aborting a `rtp` request.\n")
    private final int maxTryTimes;

    public class_3218 toDimension() {
        return RegistryHelper.ofServerWorld(this.dimension);
    }

    public TeleportSetup(String dimension, int centerX, int centerZ, boolean circle, int minRange, int maxRange, int minY, int maxY, int maxTryTimes) {
        this.dimension = dimension;
        this.centerX = centerX;
        this.centerZ = centerZ;
        this.circle = circle;
        this.minRange = minRange;
        this.maxRange = maxRange;
        this.minY = minY;
        this.maxY = maxY;
        this.maxTryTimes = maxTryTimes;
    }

    public String getDimension() {
        return this.dimension;
    }

    public int getCenterX() {
        return this.centerX;
    }

    public int getCenterZ() {
        return this.centerZ;
    }

    public boolean isCircle() {
        return this.circle;
    }

    public int getMinRange() {
        return this.minRange;
    }

    public int getMaxRange() {
        return this.maxRange;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxTryTimes() {
        return this.maxTryTimes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TeleportSetup)) {
            return false;
        }
        TeleportSetup other = (TeleportSetup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCenterX() != other.getCenterX()) {
            return false;
        }
        if (this.getCenterZ() != other.getCenterZ()) {
            return false;
        }
        if (this.isCircle() != other.isCircle()) {
            return false;
        }
        if (this.getMinRange() != other.getMinRange()) {
            return false;
        }
        if (this.getMaxRange() != other.getMaxRange()) {
            return false;
        }
        if (this.getMinY() != other.getMinY()) {
            return false;
        }
        if (this.getMaxY() != other.getMaxY()) {
            return false;
        }
        if (this.getMaxTryTimes() != other.getMaxTryTimes()) {
            return false;
        }
        String this$dimension = this.getDimension();
        String other$dimension = other.getDimension();
        return !(this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TeleportSetup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCenterX();
        result = result * 59 + this.getCenterZ();
        result = result * 59 + (this.isCircle() ? 79 : 97);
        result = result * 59 + this.getMinRange();
        result = result * 59 + this.getMaxRange();
        result = result * 59 + this.getMinY();
        result = result * 59 + this.getMaxY();
        result = result * 59 + this.getMaxTryTimes();
        String $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
        return result;
    }

    public String toString() {
        return "TeleportSetup(dimension=" + this.getDimension() + ", centerX=" + this.getCenterX() + ", centerZ=" + this.getCenterZ() + ", circle=" + this.isCircle() + ", minRange=" + this.getMinRange() + ", maxRange=" + this.getMaxRange() + ", minY=" + this.getMinY() + ", maxY=" + this.getMaxY() + ", maxTryTimes=" + this.getMaxTryTimes() + ")";
    }
}

