/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.afk;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.annotation.CommandTarget;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.event.impl.ServerLifecycleEvents;
import io.github.sakurawald.fuji.core.extension.PlayerCombatExtension;
import io.github.sakurawald.fuji.core.manager.Managers;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.afk.accessor.AfkStateAccessor;
import io.github.sakurawald.fuji.module.initializer.afk.config.model.AfkConfigModel;
import io.github.sakurawald.fuji.module.initializer.afk.job.AfkMarkerJob;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

@Document(id=1751826238005L, value="This module provides:\n1. Afk detection: If a player idle too long, we will mark it as afk state.\n2. Afk event: Execute commands when a player enters or leaves afk state.\n3. Afk name customization: For a afk player, we can customize its display name in tab list.\n")
@ColorBox(id=1751870451351L, color=ColorBox.ColorBlockTypes.NOTE, value="\u25c9 How it works?\n\nFor each player, define a `number` to track `the last action time`.\nActions can be: `mine a block`, `movement`, `issue a command` ...\nWhen action received, update the number.\nDefine a `job` using cron, to be triggered periodically.\nThe job will check and compare 2 consecutive value of the `number`.\nIf number is identical, then the player is considered as in `afk`.\n")
public class AfkInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<AfkConfigModel> config = new ObjectConfigurationHandler<AfkConfigModel>("config.json", AfkConfigModel.class);
    public static final Map<String, Long> player2prevInputCounter = new HashMap<String, Long>();

    @CommandNode(value="afk")
    @Document(id=1751826266551L, value="Enter afk state.")
    private static int $afk(@CommandSource @CommandTarget class_3222 player) {
        if (!player.method_24828() || player.method_5809() || player.field_27857 || ((PlayerCombatExtension)player).fuji$inCombat()) {
            TextHelper.sendTextByKey(player, "afk.on.failed", new Object[0]);
            return -1;
        }
        ((AfkStateAccessor)player).fuji$changeAfk(true);
        TextHelper.sendTextByKey(player, "afk.on", new Object[0]);
        return 1;
    }

    @Document(id=1751826271499L, value="Test if a player is in afk state.")
    @CommandNode(value="test-afk")
    @CommandRequirement(level=4)
    private static int $testAfk(@CommandSource class_2168 source, class_3222 player) {
        boolean value = AfkInitializer.isAfk((class_1297)player);
        return CommandHelper.Return.returnBoolean(source, value);
    }

    public static boolean isAfk(class_1297 entity) {
        if (entity instanceof class_3222) {
            AfkStateAccessor afkStateAccessor = (AfkStateAccessor)entity;
            return afkStateAccessor.fuji$isAfk();
        }
        return false;
    }

    public static void countAction(class_3222 player) {
        if (player instanceof class_3222) {
            AfkStateAccessor ex = (AfkStateAccessor)player;
            ex.fuji$incrInputCounter();
        }
    }

    public static class_2561 getAfkText(class_3222 player) {
        return TextHelper.getTextByValue(player, AfkInitializer.config.model().afk_display_name_format, new Object[0]);
    }

    public static boolean isPlayerVelocityNotZero(class_1313 movementType, class_243 vec3d) {
        if (movementType == class_1313.field_6305) {
            return Double.compare(vec3d.field_1352, 0.0) != 0 || Double.compare(vec3d.field_1351, 0.0) != 0 || Double.compare(vec3d.field_1350, 0.0) != 0;
        }
        return false;
    }

    @Override
    protected void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            AfkMarkerJob afkMarkerJob = new AfkMarkerJob();
            Managers.getScheduleManager().scheduleJob(afkMarkerJob);
        });
    }
}

