/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.anti_build;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.DocStringProvider;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.descriptor.PermissionDescriptor;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.anti_build.config.model.AntiBuildConfigModel;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Document(id=1751825625507L, value="This module allows you to ban `types of actions` for players.\n\nCurrently supported types are:\n1. Break a specified block.\n2. Place a specified block.\n3. Interact with a specified item.\n4. Interact with a specified block.\n5. Interact with a specified entity.\n")
@ColorBoxes(value={@ColorBox(id=1751896813134L, color=ColorBox.ColorBlockTypes.TIPS, value="Read the document to see the definition of `identifier` in Minecraft.\n"), @ColorBox(id=1751896904529L, color=ColorBox.ColorBlockTypes.TIPS, value="Use the `command suggestion` from `luckperms` mod to see the supported types by this module.\n"), @ColorBox(id=1751897087633L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 To ban the placement of TNT block:\nJust add the `minecraft:tnt` into the `place_block` list.\n"), @ColorBox(id=1751897135695L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 To ban the placement of TNT block, but allow a specific player to use it.\nGrant a `bypass permission` for that player: `/lp user \\<player\\> permission set fuji.anti_build.place_block.bypass.minecraft:tnt`.\n"), @ColorBox(id=1751897263346L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Dis-allow to place any blocks.\nUse `*` as the wildcard character, put it into the `place_block` list.\n")})
public class AntiBuildInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<AntiBuildConfigModel> config = new ObjectConfigurationHandler<AntiBuildConfigModel>("config.json", AntiBuildConfigModel.class);
    @DocStringProvider(id=1751999560958L, value="To bypass a specific `anti type` with a specific `id`.\n\nFor example, the permission `fuji.anti_build.place_block.bypass.minecraft:tnt` allows a player to place the TNT block.\n")
    private static final PermissionDescriptor ANTI_BUILD_BYPASS_PERMISSION = new PermissionDescriptor("fuji.anti_build.<anti-type>.bypass.<id>", 1751999560958L);

    public static <T> void checkAntiBuild(class_1657 player, String antiType, Set<String> ids, String id, CallbackInfoReturnable<T> cir, T cancelWithValue, Supplier<Boolean> shouldSendFeedback) {
        if (AntiBuildInitializer.shouldWeCancelTheAction(player, antiType, ids, id)) {
            if (shouldSendFeedback.get().booleanValue()) {
                TextHelper.sendTextByKey(player, "anti_build.disallow", new Object[0]);
            }
            cir.setReturnValue(cancelWithValue);
        }
    }

    private static boolean shouldWeCancelTheAction(class_1657 player, String antiType, Set<String> ids, String id) {
        if (AntiBuildInitializer.isAllowedByPermission(player, antiType, id)) {
            return false;
        }
        return AntiBuildInitializer.isDisallowedByConfigurationFile(ids, id);
    }

    private static boolean isDisallowedByConfigurationFile(Set<String> ids, String id) {
        return ids.contains(id) || ids.contains("*");
    }

    private static boolean isAllowedByPermission(class_1657 player, String antiType, String id) {
        return Optional.ofNullable(player).map(p -> LuckpermsHelper.hasPermission(player.method_5667(), ANTI_BUILD_BYPASS_PERMISSION, antiType, id)).orElse(false);
    }
}

