/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.back;

import com.mojang.brigadier.context.CommandContext;
import io.github.sakurawald.fuji.core.auxiliary.ChronosUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.annotation.CommandTarget;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.Dimension;
import io.github.sakurawald.fuji.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.DocStringProvider;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.descriptor.MetaDescriptor;
import io.github.sakurawald.fuji.core.structure.GlobalPos;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.back.config.model.BackConfigModel;
import io.github.sakurawald.fuji.module.initializer.back.config.model.BackLocationHistoryModel;
import io.github.sakurawald.fuji.module.initializer.back.structure.LocationEntry;
import io.github.sakurawald.fuji.module.initializer.back.structure.LocationHistory;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Document(id=1751825568845L, value="THis module allows the player to teleport back to:\n1. His last teleport point.\n2. His death point.\n")
public class BackInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<BackConfigModel> config = new ObjectConfigurationHandler<BackConfigModel>("config.json", BackConfigModel.class);
    private static final BaseConfigurationHandler<BackLocationHistoryModel> savedPositionConfig = new ObjectConfigurationHandler<BackLocationHistoryModel>("location-history.json", BackLocationHistoryModel.class).setAutoSaveEveryMinute();
    @DocStringProvider(id=1751999540893L, value="The max location entries to save for this player.\n")
    private static final MetaDescriptor<Integer> MAX_LOCATION_ENTRIES_TO_SAVE_META = new MetaDescriptor<Integer>("fuji.back.max_location_entries_to_save", Integer::valueOf, 1751999540893L);

    private static <R> R withLocationHistory(@NotNull class_3222 player, Function<LocationHistory, R> function) {
        String playerName = player.method_7334().getName();
        BackInitializer.savedPositionConfig.model().player2history.computeIfAbsent(playerName, k -> new LocationHistory());
        LocationHistory locationHistory = BackInitializer.savedPositionConfig.model().player2history.get(playerName);
        return function.apply(locationHistory);
    }

    @Document(id=1751825574805L, value="Push current location into the back location history.")
    @CommandNode(value="back push")
    @CommandRequirement(level=4)
    private static int $push(@CommandSource @CommandTarget class_3222 player) {
        return BackInitializer.withLocationHistory(player, locationHistory -> {
            LocationEntry locationEntry = LocationEntry.makeLocationEntry(player);
            BackInitializer.pushEntryAndTrim(player, locationHistory, locationEntry);
            return 1;
        });
    }

    @Document(id=1751825581305L, value="Clear the back location history.")
    @CommandNode(value="back clear")
    @CommandRequirement(level=4)
    private static int $clear(@CommandSource CommandContext<class_2168> source, @CommandTarget class_3222 player) {
        return BackInitializer.withLocationHistory(player, locationHistory -> {
            locationHistory.clearEntries();
            TextHelper.sendTextByKey(source, "back.clear", player.method_7334().getName());
            return 1;
        });
    }

    @Document(id=1751825587373L, value="List the back location history.")
    @CommandNode(value="back list")
    @CommandRequirement(level=4)
    private static int $list(@CommandSource CommandContext<class_2168> source, class_3222 player) {
        return BackInitializer.backListWithParameters((class_2168)source.getSource(), player);
    }

    @Document(id=1751825593993L, value="List the back location history.")
    @CommandNode(value="back list")
    private static int $list(@CommandSource class_3222 source) {
        return BackInitializer.backListWithParameters(source.method_5671(), source);
    }

    private static Integer backListWithParameters(class_2168 source, class_3222 player) {
        return BackInitializer.withLocationHistory(player, locationHistory -> {
            String targetPlayerName = player.method_7334().getName();
            TextHelper.sendTextByKey(source, "back.list", targetPlayerName);
            locationHistory.listEntries().forEachRemaining(it -> {
                GlobalPos location = it.getLocation();
                TextHelper.sendTextByKey(source, "back.list.entry", location.getLevel(), location.getX(), location.getY(), location.getZ(), ChronosUtil.toDefaultDateFormat(it.getSavedTimestamp()));
            });
            return 1;
        });
    }

    @Document(id=1751825598230L, value="Back to the specified location.")
    @CommandNode(value="back")
    private static int $back(@CommandSource class_3222 player) {
        return BackInitializer.backWithParameters(player, 1, null);
    }

    @Document(id=1751825604578L, value="Back to the specified location.")
    @CommandNode(value="back")
    private static int $back(@CommandSource class_3222 player, int lastNLocation) {
        return BackInitializer.backWithParameters(player, lastNLocation, null);
    }

    @Document(id=1751825608994L, value="Back to the specified location.")
    @CommandNode(value="back")
    private static int $back(@CommandSource class_3222 player, int lastNLocation, Dimension targetDimension) {
        return BackInitializer.backWithParameters(player, lastNLocation, targetDimension);
    }

    @Document(id=1751825615959L, value="Back to the specified location.")
    @CommandNode(value="back")
    private static int $back(@CommandSource class_3222 player, Dimension targetDimension) {
        return BackInitializer.backWithParameters(player, 1, targetDimension);
    }

    private static int backWithParameters(@NotNull class_3222 player, int lastNLocation, @Nullable Dimension targetDimension) {
        return BackInitializer.withLocationHistory(player, locationHistory -> {
            LocationEntry latestEntry = locationHistory.findEntry(lastNLocation, targetDimension);
            if (latestEntry == null) {
                TextHelper.sendTextByKey(player, "back.no_previous_position", new Object[0]);
                throw new AbortCommandExecutionException();
            }
            latestEntry.getLocation().teleport(player);
            return 1;
        });
    }

    private static int getMaxBackLocationEntriesToSave(@NotNull class_3222 player) {
        Optional<Integer> value = LuckpermsHelper.getMeta(player.method_5667(), MAX_LOCATION_ENTRIES_TO_SAVE_META, new Object[0]);
        return value.orElse(BackInitializer.config.model().max_back_location_entries_to_save);
    }

    private static boolean shouldSaveCurrentLocation(@NotNull class_3222 player) {
        return BackInitializer.withLocationHistory(player, locationHistory -> {
            LocationEntry latestEntry = locationHistory.getLatestEntry();
            if (latestEntry == null) {
                return true;
            }
            GlobalPos latestLocation = latestEntry.getLocation();
            double ignoreDistance = BackInitializer.config.model().ignore_distance;
            if (latestLocation.sameLevel(player.method_37908()) && player.method_19538().method_1028(latestLocation.getX(), latestLocation.getY(), latestLocation.getZ()) <= ignoreDistance * ignoreDistance) {
                return false;
            }
            return true;
        });
    }

    public static void trySaveCurrentLocation(@NotNull class_3222 player) {
        BackInitializer.withLocationHistory(player, locationHistory -> {
            if (BackInitializer.shouldSaveCurrentLocation(player)) {
                LocationEntry locationEntry = LocationEntry.makeLocationEntry(player);
                BackInitializer.pushEntryAndTrim(player, locationHistory, locationEntry);
            }
            return null;
        });
    }

    private static void pushEntryAndTrim(@NotNull class_3222 player, @NotNull LocationHistory locationHistory, @NotNull LocationEntry locationEntry) {
        locationHistory.pushEntry(locationEntry);
        locationHistory.trimEntries(BackInitializer.getMaxBackLocationEntriesToSave(player));
    }

    public static void trySaveCurrentLocationOnTeleport(class_3222 player) {
        if (BackInitializer.config.model().enable_back_on_teleport) {
            BackInitializer.trySaveCurrentLocation(player);
        }
    }
}

