/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.chat.history;

import com.google.common.collect.EvictingQueue;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.chat.history.config.model.ChatHistoryConfigModel;
import java.util.Queue;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

@Document(id=1751826684077L, value="This module will store chat message as history.\nAnd send them to the player joined the server.\n")
@ColorBox(id=1751870560992L, color=ColorBox.ColorBlockTypes.TIPS, value="\u25c9 This module works with `Styled Chat` mod.\nYou can use this module to provide the `chat history` for it.\n")
public class ChatHistoryInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<ChatHistoryConfigModel> config = new ObjectConfigurationHandler<ChatHistoryConfigModel>("config.json", ChatHistoryConfigModel.class);
    private static Queue<class_2561> chatHistory;

    public static boolean isMessageTypeFiltered(String messageTypeAsString) {
        LogUtil.debug("message type = {}", messageTypeAsString);
        boolean filtered = false;
        if (ChatHistoryInitializer.config.model().message_type_filters.stream().anyMatch(messageTypeAsString::equals)) {
            filtered = true;
        }
        if (!filtered) {
            LogUtil.debug("One filter EXCLUDES a message: message type = {}", messageTypeAsString);
        }
        return filtered;
    }

    public static boolean isMessageRejected(String contentString, String parametersString) {
        LogUtil.debug("content = {}, parameters = {}", contentString, parametersString);
        boolean rejected = false;
        if (ChatHistoryInitializer.config.model().message_rejectors.content_rejector.rules.stream().anyMatch(contentString::contains)) {
            rejected = true;
        }
        if (ChatHistoryInitializer.config.model().message_rejectors.parameter_rejector.rules.stream().anyMatch(parametersString::contains)) {
            rejected = true;
        }
        if (rejected) {
            LogUtil.debug("One rejector REJECTS a message: content = {}, parameters = {}", contentString, parametersString);
        }
        return rejected;
    }

    @Override
    protected void onInitialize() {
        chatHistory = EvictingQueue.create((int)ChatHistoryInitializer.config.model().buffer_size);
    }

    @Override
    protected void onReload() {
        EvictingQueue newQueue = EvictingQueue.create((int)ChatHistoryInitializer.config.model().buffer_size);
        newQueue.addAll(chatHistory);
        chatHistory.clear();
        chatHistory = newQueue;
    }

    public static void enrichChatHistory(class_2561 text) {
        chatHistory.add(text);
    }

    public static void replayChatHistory(class_3222 player) {
        chatHistory.forEach(arg_0 -> ((class_3222)player).method_43496(arg_0));
    }
}

