/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.chat.mention;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.job.impl.PlaySoundJob;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.chat.mention.config.model.ChatMentionConfigModel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Document(id=1751826738578L, value="This module allows you to mention another online player in chat:\n1. The target player name will be highlighted.\n2. The target player will be sound notified.\n")
@ColorBox(id=1751870571897L, color=ColorBox.ColorBlockTypes.WARNING, value="\u25c9 This module work partially with `Styled Chat` mod.\nYou can use this module with that mod.\nIt works, but you will not get the `mention player` rendered in chat.\nOther things like the `sound notify` will still work.\n")
public class ChatMentionInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<ChatMentionConfigModel> config = new ObjectConfigurationHandler<ChatMentionConfigModel>("config.json", ChatMentionConfigModel.class);

    private static List<class_3222> resolveMentionedOnlinePlayers(String chatString) {
        String[] onlinePlayerNames = ServerHelper.getServer().method_3858();
        List<class_3222> mentionedPlayers = Arrays.stream(onlinePlayerNames).filter(chatString::contains).sorted(Comparator.comparingInt(String::length).reversed()).map(ServerHelper::getOnlinePlayerByName).toList();
        if (!mentionedPlayers.isEmpty()) {
            LogUtil.debug("Submit new mention job: mentionedPlayers = {}", mentionedPlayers.stream().map(PlayerHelper::getPlayerName));
            PlaySoundJob.scheduleJob(ChatMentionInitializer.config.model().mention_player, mentionedPlayers);
        }
        return mentionedPlayers;
    }

    public static class_2561 replaceMentionText(@NotNull class_2561 original) {
        String chatString = TextHelper.Operators.visitString(original);
        List<class_3222> mentionedPlayers = ChatMentionInitializer.resolveMentionedOnlinePlayers(chatString);
        for (class_3222 mentionedPlayer : mentionedPlayers) {
            String playerName = mentionedPlayer.method_7334().getName();
            String replacementString = ChatMentionInitializer.config.model().mention_format.formatted(playerName);
            class_2561 replacementText = TextHelper.getTextByValue(mentionedPlayer, replacementString, new Object[0]);
            original = TextHelper.Operators.replaceTextWithRegex(original, playerName, () -> replacementText);
        }
        return original;
    }
}

