/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.chat.spy;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.chat.spy.config.model.ChatSpyConfigModel;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7471;

@Document(id=1751826708198L, value="This module allows you to spy on specified chat message type. (Mainly used for private message types)\n")
@ColorBox(id=1751899727098L, color=ColorBox.ColorBlockTypes.NOTE, value="Pick a good implementation of `chat spy` in fabric platform is hard.\nIn vanilla Minecraft, each chat message has its `message type`.\nYou can identify the `private chat` from its `message type`.\nThough not all other chat mods respect this point.\nYou can issue `/fuji debug` to enable the `debug mode`.\nAnd see how the `chat.spy` module works.\n")
@CommandNode(value="chat spy")
@CommandRequirement(level=4)
public class ChatSpyInitializer
extends ModuleInitializer {
    private static String lastContentString = "";
    public static final BaseConfigurationHandler<ChatSpyConfigModel> config = new ObjectConfigurationHandler<ChatSpyConfigModel>("config.json", ChatSpyConfigModel.class);

    @Document(id=1751826711342L, value="Enable/disable the chat spy mode for you.")
    @CommandNode(value="toggle")
    private static int $toggle(@CommandSource class_3222 player) {
        ChatSpyConfigModel.PerPlayerOptions options = ChatSpyInitializer.withOptions(player);
        options.enabled = !options.enabled;
        config.writeStorage();
        TextHelper.sendTextByKey(player, options.enabled ? "on" : "off", new Object[0]);
        return 1;
    }

    private static void ensureOptionsExists(class_3222 player) {
        String key = player.method_7334().getName();
        config.model().getOptions().putIfAbsent(key, new ChatSpyConfigModel.PerPlayerOptions());
    }

    public static ChatSpyConfigModel.PerPlayerOptions withOptions(class_3222 player) {
        ChatSpyInitializer.ensureOptionsExists(player);
        return config.model().getOptions().get(player.method_7334().getName());
    }

    public static void processChatSpy(String messageTypeString, class_3222 receiverPlayer, class_7471 signedMessage, class_2556.class_7602 parameters) {
        LogUtil.debug("Receive a message with message type {}", messageTypeString);
        if (ChatSpyInitializer.config.model().message_type.whitelist.stream().noneMatch(it -> it.matches(messageTypeString))) {
            return;
        }
        class_2561 content = parameters.method_44837(signedMessage.method_46291());
        String contentString = content.getString();
        if (ChatSpyInitializer.config.model().ignore_consecutive_same_text && contentString.equals(lastContentString)) {
            return;
        }
        lastContentString = contentString;
        class_2561 receiverPlayerName = receiverPlayer.method_5476();
        class_5250 notificationText = class_2561.method_43473();
        notificationText.method_10852(content).method_10852(TextHelper.TEXT_SPACE).method_10852(TextHelper.getTextByKey(null, "chat.spy.indicator", new Object[0])).method_10852(TextHelper.TEXT_SPACE).method_10852(receiverPlayerName);
        if (ChatSpyInitializer.config.model().log_console) {
            LogUtil.info(notificationText.getString(), new Object[0]);
        }
        ServerHelper.getOnlinePlayers().stream().filter(it -> ChatSpyInitializer.withOptions((class_3222)it).enabled).forEach(it -> it.method_43496((class_2561)notificationText));
    }
}

