/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.chat.style;

import eu.pb4.placeholders.api.parsers.NodeParser;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.annotation.CommandTarget;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.service.style_striper.StyleStriper;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.chat.style.model.ChatFormatModel;
import io.github.sakurawald.fuji.module.initializer.chat.style.model.ChatStyleConfigModel;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7463;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

@Document(id=1751826676414L, value="This module allows you to customize global chat style.\nBesides, players can use `/chat style` to set per-player chat style.\n")
@ColorBoxes(value={@ColorBox(id=1751870542664L, color=ColorBox.ColorBlockTypes.WARNING, value="If you are using `Styled Chat` mod, then you can `disable` this module.\nBecause they provide the same `purpose`.\n"), @ColorBox(id=1751870544482L, color=ColorBox.ColorBlockTypes.TIPS, value="\u25c9 The main features of this module:\n1. You can use `style tags` to define complex `format`.\n2. You can define the `global format` for all players.\n3. A player can set its `personal format` using `/chat style` command.\n4. This module is designed to work with other `chat-related` mods.\n5. You can control what style tags a player can use, using permissions.\n"), @ColorBox(id=1751870547482L, color=ColorBox.ColorBlockTypes.TIPS, value="\u25c9 You can use `style tags` to write `complex format`.\n\nSee the language grammar here:\n1. https://docs.advntr.dev/minimessage/format.html\n2. https://placeholders.pb4.eu/user/quicktext\n"), @ColorBox(id=1751870549047L, color=ColorBox.ColorBlockTypes.TIPS, value="\u25c9 To set the `prefix` and `suffix` for a player.\n\nYou need to install the `luckperms` mod, to provide the `prefix` and `suffix` feature.\nAfter install it, issue `/lp group default meta setprefix \\<yellow\\>[awesome]` to assign a `prefix`.\nTo use the `prefix`, use the placeholder `%fuji:player_prefix%`.\n"), @ColorBox(id=1751870550677L, color=ColorBox.ColorBlockTypes.TIPS, value="\u25c9 To set the per-player chat style:\nIssue `/chat style set prefix + %message% + suffix`.\n"), @ColorBox(id=1751870552243L, color=ColorBox.ColorBlockTypes.TIPS, value="\u25c9 To allow players to use `\\<blue\\>` tag:\nIssue `/lp group default permission set fuji.style.chat.blue`.\n"), @ColorBox(id=1751870553872L, color=ColorBox.ColorBlockTypes.TIPS, value="\u25c9 To allow players to use `\\<b\\>` tag:\nIssue `/lp group default permission set fuji.style.chat.b`.\n"), @ColorBox(id=1751870555712L, color=ColorBox.ColorBlockTypes.TIPS, value="\u25c9 To allow players to use all tags:\nAll tags also including dangerous tags like `\\<click\\>` tag which can run commands on clicked!\nIssue `/lp group default permission set fuji.style.chat.*`\n"), @ColorBox(id=1752175232049L, color=ColorBox.ColorBlockTypes.TIPS, value="\u25c9 Customize the chat format using placeholders.\nYou may want to enable `placeholder` module, to provide more useful placeholders.\n")})
@CommandNode(value="chat style")
public class ChatStyleInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<ChatStyleConfigModel> config = new ObjectConfigurationHandler<ChatStyleConfigModel>("config.json", ChatStyleConfigModel.class);
    public static final class_5321<class_2556> MESSAGE_TYPE_KEY = class_5321.method_29179((class_5321)class_7924.field_41237, (class_2960)class_2960.method_43902((String)"fuji", (String)("chat_" + FabricLoader.getInstance().getEnvironmentType().toString().toLowerCase())));
    public static final class_2556 MESSAGE_TYPE_VALUE = new class_2556(class_7463.method_43831((String)"%s%s"), class_7463.method_43831((String)"%s%s"));
    private static final BaseConfigurationHandler<ChatFormatModel> chatFormatData = new ObjectConfigurationHandler<ChatFormatModel>("chat.json", ChatFormatModel.class);
    private static final NodeParser CHAT_STYLE_PARSER = TextHelper.Parsers.MINI_MESSAGE_ONLY_PARSER;
    private static final String DEFAULT_CONTENT_FORMAT = "%message%";
    private static final String CHAT_STYLE_TYPE = "chat";

    private static String stripeStyleTags(class_1657 player, String string) {
        return StyleStriper.stripe(player, CHAT_STYLE_TYPE, string);
    }

    @Document(id=1751826679326L, value="Set your personal chat content format.\nFor example: `/chat style set prefix + %message% + suffix`\n")
    @CommandNode(value="set")
    private static int $setPerPlayerFormat(@CommandSource @CommandTarget class_3222 player, GreedyString format) {
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        String newFormat = (String)format.getValue();
        String stripedFormat = newFormat = ChatStyleInitializer.stripeStyleTags((class_1657)player, newFormat);
        ChatStyleInitializer.chatFormatData.model().format.player2format.put(playerName, newFormat);
        chatFormatData.writeStorage();
        newFormat = TextHelper.Translator.getLanguageValueByKey(player, "chat.format.set");
        newFormat = newFormat.replace("%s", stripedFormat);
        newFormat = newFormat.replace(DEFAULT_CONTENT_FORMAT, TextHelper.Translator.getLanguageValueByKey(player, "chat.format.show"));
        class_2561 text = TextHelper.getTextByValue(player, newFormat, new Object[0]);
        player.method_43496(text);
        return 1;
    }

    @Document(id=1751826681754L, value="Reset your personal chat content format.")
    @CommandNode(value="reset")
    private static int $resetPerPlayerFormat(@CommandSource @CommandTarget class_3222 player) {
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        ChatStyleInitializer.chatFormatData.model().format.player2format.remove(playerName);
        chatFormatData.writeStorage();
        TextHelper.sendTextByKey(player, "chat.format.reset", new Object[0]);
        return 1;
    }

    @NotNull
    public static class_2561 parseSenderText(@NotNull class_3222 player) {
        String senderString = ChatStyleInitializer.config.model().style.sender;
        return TextHelper.getTextByValue(player, senderString, new Object[0]);
    }

    @NotNull
    public static class_2561 parseContentText(@NotNull class_3222 player, String message) {
        String contentString = ChatStyleInitializer.config.model().style.content.formatted(message);
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        contentString = ChatStyleInitializer.chatFormatData.model().format.player2format.getOrDefault(playerName, DEFAULT_CONTENT_FORMAT).replace(DEFAULT_CONTENT_FORMAT, contentString);
        contentString = ChatStyleInitializer.stripeStyleTags((class_1657)player, contentString);
        return TextHelper.Parsers.parseString(CHAT_STYLE_PARSER, contentString);
    }
}

