/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.chat.trigger;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.StringUtil;
import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.chat.trigger.config.model.ChatTriggerConfigModel;
import io.github.sakurawald.fuji.module.initializer.chat.trigger.structure.ChatTrigger;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_2168;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Document(id=1751826730890L, value="This module allows you to define magic spells in chat, to execute commands.\n")
@ColorBoxes(value={@ColorBox(id=1751899049909L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 To define a simple magic spell in chat string.\nRegex: `magic`\nCommands: `say magic!`\n"), @ColorBox(id=1751899198263L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 To define a complex magic spell with arguments in chat string.\nRegex: `i am (.+)`\nCommands:\n1. `say You just said: $0`\n2. `say Hello $1`\n"), @ColorBox(id=1751899201560L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 To define a shortcut for chat display module with Styled Chat mod.\nRegex: `(?<=^|\\\\s)item(?=\\\\s|$)`\nCommands: `run as fake-op %player:name% chat display item`\n")})
public class ChatTriggerInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<ChatTriggerConfigModel> config = new ObjectConfigurationHandler<ChatTriggerConfigModel>("config.json", ChatTriggerConfigModel.class);

    public static String processChatTriggers(class_2168 source, String chatString, CallbackInfo ci) {
        LogUtil.debug("Process Chat Triggers: chatString = {}", chatString);
        List<ChatTrigger> triggers = ChatTriggerInitializer.config.model().triggers;
        triggers.stream().filter(it -> chatString.matches(it.regex)).forEach(it -> {
            Matcher matcher = Pattern.compile(it.regex).matcher(chatString);
            matcher.find();
            List commands = it.commands.stream().map(cmd -> StringUtil.replaceGroupsPlaceholders(matcher, cmd)).collect(Collectors.toCollection(ArrayList::new));
            LogUtil.debug("Execute commands {} for {}", commands, it);
            commands.forEach(cmd -> CommandExecutor.execute(ExtendedCommandSource.asConsole(source), cmd));
        });
        return chatString;
    }
}

