/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.cleaner;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.EntityHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ItemStackHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.event.impl.ServerLifecycleEvents;
import io.github.sakurawald.fuji.core.manager.Managers;
import io.github.sakurawald.fuji.core.service.type_formatter.TypeFormatter;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.cleaner.config.model.CleanerConfigModel;
import io.github.sakurawald.fuji.module.initializer.cleaner.job.CleanerJob;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

@Document(id=1751826898176L, value="This module provides the `entity` cleaner.\nTo remove specified entities automatically.\n")
@ColorBoxes(value={@ColorBox(id=1751870582940L, color=ColorBox.ColorBlockTypes.NOTE, value="You should only use this module to clean some edge-case entity.\nThe vanilla Minecraft also has a `cleaner` to remove dropped items.\nIn normal case, you can rely on the `vanilla cleaner`.\nBut for some special case, you may want to use this module.\nTo clean some `annoying dropped items` or even `entities` (`pig` or `boat`).\n\nYeah, the `vanilla cleaner` only cleans `dropped items`.\nBut this module, allows you to define rules, to clean `dropped items` and `entities`.\n"), @ColorBox(id=1751870585373L, color=ColorBox.ColorBlockTypes.NOTE, value="For safety, the `cleaner` will `always ignore` the following types:\n1. player\n2. any block attached entity (e.g. leash_knot)\n3. any vehicle entity (e.g. minecart, boat)\n")})
@CommandNode(value="cleaner")
@CommandRequirement(level=4)
public class CleanerInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<CleanerConfigModel> config = new ObjectConfigurationHandler<CleanerConfigModel>("config.json", CleanerConfigModel.class);

    private static boolean shouldIgnoreEntity(class_1297 entity) {
        if (entity.method_5864().equals(class_1299.field_6097)) {
            return true;
        }
        if (EntityHelper.isBlockAttachedEntity(entity)) {
            return true;
        }
        if (EntityHelper.isVehicleEntity(entity)) {
            return true;
        }
        CleanerConfigModel.Ignore config = CleanerInitializer.config.model().ignore;
        if (config.ignore_item_entity && entity instanceof class_1542) {
            return true;
        }
        if (config.ignore_living_entity && entity.method_5709()) {
            return true;
        }
        if (config.ignore_named_entity) {
            class_1542 ie;
            class_1799 stack;
            if (entity.method_16914()) {
                return true;
            }
            if (entity instanceof class_1542 && ItemStackHelper.hasCustomName(stack = (ie = (class_1542)entity).method_6983())) {
                return true;
            }
        }
        if (config.ignore_entity_with_vehicle && entity.method_5765()) {
            return true;
        }
        if (config.ignore_entity_with_passengers && entity.method_5782()) {
            return true;
        }
        if (config.ignore_glowing_entity && entity.method_5851()) {
            return true;
        }
        return config.ignore_leashed_entity && EntityHelper.isLeashed(entity);
    }

    private static boolean shouldRemoveThisEntity(String key, int age) {
        Map<String, Integer> key2age = CleanerInitializer.config.model().key2age;
        return key2age.containsKey(key) && age >= key2age.get(key);
    }

    @Document(id=1751826901492L, value="Trigger the cleaner once.")
    @CommandNode(value="clean")
    public static int $clean() {
        HashMap<String, Integer> cleanedEntities = new HashMap<String, Integer>();
        for (class_3218 world : ServerHelper.getWorlds()) {
            for (class_1297 entity : world.method_27909()) {
                String key;
                if (CleanerInitializer.shouldIgnoreEntity(entity) || !CleanerInitializer.shouldRemoveThisEntity(key = CleanerInitializer.getTranslatableKey(entity), entity.field_6012)) continue;
                Integer originalAmount = cleanedEntities.getOrDefault(key, 0);
                cleanedEntities.put(key, originalAmount + 1);
                entity.method_31472();
            }
        }
        CleanerInitializer.sendCleanerBroadcast(cleanedEntities);
        return 1;
    }

    private static String getTranslatableKey(class_1297 entity) {
        String key;
        if (entity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entity;
            key = itemEntity.method_6983().method_7909().method_7876();
        } else {
            key = entity.method_5864().method_5882();
        }
        return key;
    }

    private static void sendCleanerBroadcast(Map<String, Integer> counter) {
        if (counter.isEmpty()) {
            return;
        }
        LogUtil.info("Remove entities: {}", counter);
        class_5250 hoverText = class_2561.method_43473().method_27692(class_124.field_1065).method_10852(TypeFormatter.formatTypes(null, counter));
        for (class_3222 player : ServerHelper.getOnlinePlayers()) {
            int numberOfCleanedEntities = counter.values().stream().mapToInt(Integer::intValue).sum();
            class_5250 reportText = class_2561.method_43473().method_10852(TextHelper.getTextByKey(player, "cleaner.broadcast", numberOfCleanedEntities)).method_27696(class_2583.field_24360.method_10949(TextHelper.Events.HoverEvent.makeShowTextAction((class_2561)hoverText)));
            player.method_43496((class_2561)reportText);
        }
    }

    @Override
    protected void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            CleanerJob cleanerJob = new CleanerJob();
            Managers.getScheduleManager().scheduleJob(cleanerJob);
        });
    }
}

