/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_advice;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.StringUtil;
import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.command_advice.model.CommandAdviceConfigModel;
import io.github.sakurawald.fuji.module.initializer.command_advice.structure.CommandAdviceType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_2168;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Document(id=1751826306321L, value="This module allows you to decorate existing commands:\n1. Run other commands `before` execution the target command.\n2. Run other commands `after` execution the target command.\n3. Cancel the execution of the target command, and run other commands.\n")
@ColorBoxes(value={@ColorBox(id=1751900137390L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="Execute other commands before/after a target command.\n"), @ColorBox(id=1751900375812L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="Decorate an existing command with other commands.\n"), @ColorBox(id=1751900379675L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="Cancel the execution of the target command, and execute other commands instead.\n"), @ColorBox(id=1751900258020L, color=ColorBox.ColorBlockTypes.TIPS, value="This module provides `similar` functions to `command_bundle` module.\n")})
public class CommandAdviceInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<CommandAdviceConfigModel> config = new ObjectConfigurationHandler<CommandAdviceConfigModel>("config.json", CommandAdviceConfigModel.class);

    public static void processCommandAdvice(Object handler, class_2168 source, String commandString, CommandAdviceType adviceType, CallbackInfo ci) {
        LogUtil.debug("Process Command Advice: advice type = {}, command string = {}, command source = {}, handler = {}, ", new Object[]{adviceType, commandString, source.method_9214(), handler});
        List targetAdviceEntries = CommandAdviceInitializer.config.model().entries.stream().filter(it -> it.adviceType.equals((Object)adviceType) || it.adviceType.equals((Object)CommandAdviceType.CANCEL_WITH_SUCCESS) && adviceType.equals((Object)CommandAdviceType.BEFORE_EXECUTING)).collect(Collectors.toCollection(ArrayList::new));
        targetAdviceEntries = targetAdviceEntries.stream().filter(it -> !it.onlyValidWhenCommandIsExecutedByPlayer || source.method_43737()).collect(Collectors.toCollection(ArrayList::new));
        targetAdviceEntries.stream().filter(it -> commandString.matches(it.matchCommandStringRegex)).forEach(it -> {
            if (it.adviceType.equals((Object)CommandAdviceType.CANCEL_WITH_SUCCESS)) {
                LogUtil.debug("Cancel the executing of target command {} with success for {}", commandString, it);
                if (ci instanceof CallbackInfoReturnable) {
                    ((CallbackInfoReturnable)ci).setReturnValue((Object)1);
                } else {
                    ci.cancel();
                }
            }
            Matcher matcher = Pattern.compile(it.matchCommandStringRegex).matcher(commandString);
            matcher.find();
            List commands = it.commands.stream().map(cmd -> StringUtil.replaceGroupsPlaceholders(matcher, cmd)).collect(Collectors.toCollection(ArrayList::new));
            LogUtil.debug("Execute commands {} for {}", commands, it);
            commands.forEach(cmd -> CommandExecutor.execute(ExtendedCommandSource.asConsole(source), cmd));
        });
    }
}

