/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_alias;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.event.impl.ServerLifecycleEvents;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.command_alias.config.model.CommandAliasConfigModel;
import io.github.sakurawald.fuji.module.initializer.command_alias.structure.CommandPathMappingNode;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import org.jetbrains.annotations.NotNull;

@Document(id=1751826302190L, value="This module allows you to define alias for existing commands.\nThe defined alies command will redirect to the existing command node.\n")
@ColorBoxes(value={@ColorBox(id=1751900420030L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Define a `new shortcut command` as an alias to `an existing command`.\nFor example:\n1. Define a new `/r` command, as alias to `/reply` command.\n2. Define a new `/sudo` command, as alias to `/run as fake-op` command.\n"), @ColorBox(id=1751900579678L, color=ColorBox.ColorBlockTypes.TIPS, value="The `command_alias` command only has the ability to define `a new command`, as the alias of `an existing command`.\nIt works by `command redirecting`.\nYou can't use `command_alias` module to actually define `a new command with arguments`, that's the weakness.\nIf you want to define `a new command with arguments`, see `command_bundle` module.\n\nIn short:\n1. To define `a simple command` with no arguments, use `command_alias` module.\n2. To define `a complex command` with arguments, use `command_bundle` module.\n")})
public class CommandAliasInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<CommandAliasConfigModel> config = new ObjectConfigurationHandler<CommandAliasConfigModel>("config.json", CommandAliasConfigModel.class);

    @Override
    protected void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            CommandDispatcher<class_2168> dispatcher = ServerHelper.getCommandDispatcher();
            CommandAliasInitializer.config.model().alias.forEach(it -> {
                assert (dispatcher != null);
                this.processCommandAliasEntry(dispatcher, (CommandPathMappingNode)it);
            });
        });
    }

    private void processCommandAliasEntry(@NotNull CommandDispatcher<class_2168> dispatcher, @NotNull CommandPathMappingNode entry) {
        LiteralArgumentBuilder builder = null;
        CommandNode target = dispatcher.findNode(entry.getTo());
        for (int i = entry.getFrom().size() - 1; i >= 0; --i) {
            String name = entry.getFrom().get(i);
            if (builder == null) {
                if (target == null) {
                    LogUtil.warn("Can't find the target command node for command alias entry: {}", entry);
                    return;
                }
                builder = (LiteralArgumentBuilder)class_2170.method_9247((String)name).redirect(target);
                continue;
            }
            builder = (LiteralArgumentBuilder)class_2170.method_9247((String)name).then(builder);
        }
        if (builder == null) {
            return;
        }
        CommandNode targetRoot = dispatcher.findNode(List.of(entry.getTo().get(0)));
        if (targetRoot != null) {
            builder.requires(targetRoot.getRequirement());
        }
        dispatcher.register(builder);
    }
}

