/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_attachment;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.EntityHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ItemStackHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.UuidHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.fuji.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.event.impl.ServerLifecycleEvents;
import io.github.sakurawald.fuji.core.manager.Managers;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.command_attachment.command.argument.wrapper.ExecuteAsType;
import io.github.sakurawald.fuji.module.initializer.command_attachment.command.argument.wrapper.InteractType;
import io.github.sakurawald.fuji.module.initializer.command_attachment.config.model.CommandAttachmentModel;
import io.github.sakurawald.fuji.module.initializer.command_attachment.job.TestSteppingOnBlockJob;
import io.github.sakurawald.fuji.module.initializer.command_attachment.structure.BlockCommandAttachmentNode;
import io.github.sakurawald.fuji.module.initializer.command_attachment.structure.CommandAttachmentNode;
import io.github.sakurawald.fuji.module.initializer.command_attachment.structure.CommandAttackmentType;
import io.github.sakurawald.fuji.module.initializer.command_attachment.structure.EntityCommandAttachmentNode;
import io.github.sakurawald.fuji.module.initializer.command_attachment.structure.ItemStackCommandAttachmentNode;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Document(id=1751826430284L, value="This module allows you to attach commands into things:\n1. Attach commands into an item stack.\n2. Attach commands into a block.\n3. Attach commands into an entity.\n")
@ColorBoxes(value={@ColorBox(id=1751870462624L, color=ColorBox.ColorBlockTypes.NOTE, value="\u25c9 How it works?\n\nWhen you attach commands into an item.\nWe will save a `binding ID` in the item NBT.\nEvery item that has the same `binding ID` in its NBT data, shares the same `binding commands instance`.\n"), @ColorBox(id=1751870464919L, color=ColorBox.ColorBlockTypes.TIPS, value="To give the item with attached commands.\nYou can use `kit` module.\nThe kit module will save the item NBT.\nSo if you define a kit, puts the magic item in it.\nThen give the kit to a player.\nThe player will get the magic item.\n"), @ColorBox(id=1751900879800L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Make a magic-stick, which heals the player on clicked.\nIssue `/command-attachment attach-item-one heal`\n"), @ColorBox(id=1751900919703L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Make a magic-stick, which:\n1. Gives diamonds * 1 on left clicked. (With use limit 3)\n2. Gives gold_ingot *1 on right clicked. (With use limit 5)\n\nIssue the following commands:\n1. `/command-attachment attach-item-one --maxUseTimes 3 --interactType LEFT give %player:name% minecraft:diamond 1`\n2. `/command-attachment attach-item-one --maxUseTimes 5 --interactType RIGHT give %player:name% minecraft:gold_ingot 1`\n"), @ColorBox(id=1751901028033L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Make a magic-stick, which gives apple * 1, with use limit 3 times, and keep the item without destroying it.\nIssue: `/command-attachment attach-item-one --maxUseTimes 3 --destroyItem false give %player:name% minecraft:apple 1`.\n"), @ColorBox(id=1751901112988L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Query the attached commands in a specific item.\nIssue `/command-attachment query-item`.\n"), @ColorBox(id=1751901147901L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Let an entity say hello on right clicked.\nIssue: `/command-attachment attach-entity-one \\<entity-id\\> say hello %player:name%`\n"), @ColorBox(id=1751901221023L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Make a portal block.\nIssue: `/command-attachment attach-block-one 0 0 0 --interactType STEP_ON tppos --targetPlayer %player:name% --dimension minecraft:the_end --x 0 --y 66 --z 0 %player:name%`.\n")})
@CommandNode(value="command-attachment")
@CommandRequirement(level=4)
public class CommandAttachmentInitializer
extends ModuleInitializer {
    private static final String COMMAND_ATTACHMENT_SUBJECT_NAME = "command-attachment";
    private static final Map<String, String> player2lastSteppingBlockUUID = new HashMap<String, String>();

    private static void testSteppingBlockForPlayer(class_3222 player) {
        String playerName = player.method_7334().getName();
        String originalUuid = player2lastSteppingBlockUUID.get(playerName);
        String uuid = UuidHelper.getAttachedUuid((class_1937)EntityHelper.getServerWorld((class_1297)player), player.method_23312());
        if (uuid.equals(originalUuid)) {
            return;
        }
        player2lastSteppingBlockUUID.put(playerName, uuid);
        ServerHelper.getServer().method_40000(() -> CommandAttachmentInitializer.tryTriggerAttachmentModel(uuid, (class_1657)player, List.of(InteractType.STEP_ON)));
    }

    public static void testSteppingBlockForPlayers() {
        ServerHelper.getOnlinePlayers().forEach(CommandAttachmentInitializer::testSteppingBlockForPlayer);
    }

    private static boolean existsAttachmentModel(@Nullable String uuid) {
        return Managers.getAttachmentManager().existsAttachment(COMMAND_ATTACHMENT_SUBJECT_NAME, uuid);
    }

    private static CommandAttachmentModel getAttachmentModel(String uuid) {
        CommandAttachmentModel model;
        try {
            String attachment = Managers.getAttachmentManager().getAttachment(COMMAND_ATTACHMENT_SUBJECT_NAME, uuid);
            model = (CommandAttachmentModel)BaseConfigurationHandler.getGson().fromJson(attachment, CommandAttachmentModel.class);
        }
        catch (IOException e) {
            model = new CommandAttachmentModel();
            String json = BaseConfigurationHandler.getGson().toJson((Object)model);
            Managers.getAttachmentManager().setAttachment(COMMAND_ATTACHMENT_SUBJECT_NAME, uuid, json);
        }
        return model;
    }

    private static void setAttachmentModel(String uuid, CommandAttachmentModel model) {
        String json = BaseConfigurationHandler.getGson().toJson((Object)model);
        Managers.getAttachmentManager().setAttachment(COMMAND_ATTACHMENT_SUBJECT_NAME, uuid, json);
    }

    public static void tryTriggerAttachmentModel(@Nullable String uuid, class_1657 player, List<InteractType> receivedInteractTypes) {
        CommandAttachmentInitializer.tryTriggerAttachmentModel(uuid, player, receivedInteractTypes, () -> {});
    }

    public static void tryTriggerAttachmentModel(@Nullable String uuid, class_1657 player, List<InteractType> receivedInteractTypes, Runnable postTriggered) {
        if (!CommandAttachmentInitializer.existsAttachmentModel(uuid)) {
            return;
        }
        CommandAttachmentInitializer.triggerAttachmentModel(uuid, player, receivedInteractTypes, postTriggered);
    }

    private static void triggerAttachmentModel(String uuid, class_1657 player, List<InteractType> receivedInteractTypes, Runnable postTriggered) {
        CommandAttachmentModel model = CommandAttachmentInitializer.getAttachmentModel(uuid);
        for (CommandAttachmentNode e : model.getEntries()) {
            ItemStackCommandAttachmentNode ie;
            if (!receivedInteractTypes.contains((Object)e.getInteractType()) || e.getUseTimes() >= e.getMaxUseTimes()) continue;
            ExecuteAsType executeAsType = e.getExecuteAsType();
            class_2168 source = CommandHelper.getCommandSource((class_1297)player);
            switch (executeAsType) {
                case CONSOLE: {
                    CommandExecutor.execute(ExtendedCommandSource.asConsole(source), e.getCommand());
                    break;
                }
                case PLAYER: {
                    CommandExecutor.execute(ExtendedCommandSource.asPlayer(source, (class_3222)player), e.getCommand());
                    break;
                }
                case FAKE_OP: {
                    CommandExecutor.execute(ExtendedCommandSource.asFakeOp(source, (class_3222)player), e.getCommand());
                }
            }
            postTriggered.run();
            e.setUseTimes(e.getUseTimes() + 1);
            if (!(e instanceof ItemStackCommandAttachmentNode) || !(ie = (ItemStackCommandAttachmentNode)e).isDestroyItem() || e.getUseTimes() < e.getMaxUseTimes()) continue;
            player.method_6047().method_7934(1);
        }
        CommandAttachmentInitializer.setAttachmentModel(uuid, model);
    }

    @Document(id=1751826433455L, value="Attach one command to an item.")
    @CommandNode(value="attach-item-one")
    private static int $attachItemOne(@CommandSource class_3222 player, @Document(id=1751826436283L, value="The interaction type to trigger this command.") Optional<InteractType> interactType, @Document(id=1751826438227L, value="Max use times of this command.") Optional<Integer> maxUseTimes, @Document(id=1751826442468L, value="Execute this command as who?") Optional<ExecuteAsType> executeAsType, @Document(id=1751826444225L, value="Should we destroy the item if the use times exceed.") Optional<Boolean> destroyItem, @Document(id=1751826447371L, value="The command.") GreedyString command) {
        return CommandHelper.Pattern.itemInHandCommand(player.method_5671(), (thePlayer, mainHandStack) -> {
            String uuid = UuidHelper.getOrSetAttachedUuid(mainHandStack);
            CommandAttachmentModel model = CommandAttachmentInitializer.getAttachmentModel(uuid);
            String $command = (String)command.getValue();
            InteractType $interactType = interactType.orElse(InteractType.BOTH);
            ExecuteAsType $executeAsType = executeAsType.orElse(ExecuteAsType.FAKE_OP);
            Integer $maxUseTimes = maxUseTimes.orElse(Integer.MAX_VALUE);
            Boolean $destroyItem = destroyItem.orElse(true);
            model.getEntries().add(new ItemStackCommandAttachmentNode($command, $interactType, $executeAsType, $maxUseTimes, 0, $destroyItem));
            CommandAttachmentInitializer.setAttachmentModel(uuid, model);
            return 1;
        });
    }

    @Document(id=1751826450179L, value="Attach one command to an entity.")
    @CommandNode(value="attach-entity-one")
    private static int $attachEntityOne(@CommandSource class_3222 player, @Document(id=1751826451977L, value="The target entity.") class_1297 entity, @Document(id=1751826454446L, value="The interaction type to trigger this command.") Optional<InteractType> interactType, @Document(id=1751826456136L, value="Max use times of this command.") Optional<Integer> maxUseTimes, @Document(id=1751826457661L, value="Execute this command as who?") Optional<ExecuteAsType> executeAsType, @Document(id=1751826459247L, value="The command") GreedyString command) {
        String uuid = entity.method_5845();
        CommandAttachmentModel model = CommandAttachmentInitializer.getAttachmentModel(uuid);
        String $command = (String)command.getValue();
        InteractType $interactType = interactType.orElse(InteractType.BOTH);
        ExecuteAsType $executeAsType = executeAsType.orElse(ExecuteAsType.FAKE_OP);
        Integer $maxUseTimes = maxUseTimes.orElse(Integer.MAX_VALUE);
        model.getEntries().add(new EntityCommandAttachmentNode($command, $interactType, $executeAsType, $maxUseTimes, 0));
        CommandAttachmentInitializer.setAttachmentModel(uuid, model);
        return 1;
    }

    @Document(id=1751826465183L, value="Attach one command to specified block.")
    @CommandNode(value="attach-block-one")
    private static int $attachBlockOne(@CommandSource class_3222 player, class_2338 blockPos, @Document(id=1751826466665L, value="The interaction type to trigger this command.") Optional<InteractType> interactType, @Document(id=1751826468188L, value="Max use times of this command.") Optional<Integer> maxUseTimes, @Document(id=1751826470533L, value="Execute this command as who?") Optional<ExecuteAsType> executeAsType, @Document(id=1751826472455L, value="The command") GreedyString command) {
        String uuid = UuidHelper.getAttachedUuid((class_1937)EntityHelper.getServerWorld((class_1297)player), blockPos);
        CommandAttachmentModel model = CommandAttachmentInitializer.getAttachmentModel(uuid);
        String $command = (String)command.getValue();
        InteractType $interactType = interactType.orElse(InteractType.BOTH);
        ExecuteAsType $executeAsType = executeAsType.orElse(ExecuteAsType.FAKE_OP);
        Integer $maxUseTimes = maxUseTimes.orElse(Integer.MAX_VALUE);
        String createdIn = UuidHelper.toString(player.method_37908(), blockPos);
        model.getEntries().add(new BlockCommandAttachmentNode(createdIn, $command, $interactType, $executeAsType, (int)$maxUseTimes, 0));
        CommandAttachmentInitializer.setAttachmentModel(uuid, model);
        return 1;
    }

    @Document(id=1751826477036L, value="Detach all attached commands in the item.")
    @CommandNode(value="detach-item-all")
    private static int $detachItemAll(@CommandSource class_3222 player) {
        return CommandHelper.Pattern.itemInHandCommand(player.method_5671(), (thePlayer, mainHandStack) -> {
            String uuid = UuidHelper.getOrSetAttachedUuid(mainHandStack);
            CommandAttachmentInitializer.doDetachAttachment(player, uuid);
            return 1;
        });
    }

    @Document(id=1751826478770L, value="Detach all attached commands in the entity.")
    @CommandNode(value="detach-entity-all")
    private static int $detachEntityAll(@CommandSource class_3222 player, class_1297 entity) {
        String uuid = entity.method_5845();
        CommandAttachmentInitializer.doDetachAttachment(player, uuid);
        return 1;
    }

    @Document(id=1751826482248L, value="Detach all attached commands in the block.")
    @CommandNode(value="detach-block-all")
    private static int $detachBlockAll(@CommandSource class_3222 player, class_2338 blockPos) {
        String uuid = UuidHelper.getAttachedUuid((class_1937)EntityHelper.getServerWorld((class_1297)player), blockPos);
        CommandAttachmentInitializer.doDetachAttachment(player, uuid);
        return 1;
    }

    private static void doDetachAttachment(class_3222 player, String uuid) {
        Managers.getAttachmentManager().unsetAttachment(COMMAND_ATTACHMENT_SUBJECT_NAME, uuid);
    }

    @Document(id=1751826486559L, value="Query all attached commands in the item.")
    @CommandNode(value="query-item")
    private static int $queryItem(@CommandSource class_3222 player) {
        return CommandHelper.Pattern.itemInHandCommand(player.method_5671(), (thePlayer, mainHandStack) -> {
            String uuid = UuidHelper.getAttachedUuid(ItemStackHelper.Nbt.getNbt(mainHandStack));
            CommandAttachmentInitializer.doQueryAttachment(player, uuid);
            return 1;
        });
    }

    @Document(id=1751826488228L, value="Query all attached commands in the entity.")
    @CommandNode(value="query-entity")
    private static int $queryEntity(@CommandSource class_3222 player, class_1297 entity) {
        String uuid = entity.method_5845();
        CommandAttachmentInitializer.doQueryAttachment(player, uuid);
        return 1;
    }

    @Document(id=1751826492923L, value="Query all attached commands in the block.")
    @CommandNode(value="query-block")
    private static int $queryBlock(@CommandSource class_3222 player, class_2338 blockPos) {
        String uuid = UuidHelper.getAttachedUuid((class_1937)EntityHelper.getServerWorld((class_1297)player), blockPos);
        CommandAttachmentInitializer.doQueryAttachment(player, uuid);
        return 1;
    }

    private static void doQueryAttachment(class_3222 player, String uuid) {
        if (!Managers.getAttachmentManager().existsAttachment(COMMAND_ATTACHMENT_SUBJECT_NAME, uuid)) {
            TextHelper.sendTextByKey(player, "command_attachment.query.no_attachment", new Object[0]);
            throw new AbortCommandExecutionException();
        }
        String attachment = Managers.getAttachmentManager().getAttachment(COMMAND_ATTACHMENT_SUBJECT_NAME, uuid);
        player.method_43496((class_2561)class_2561.method_43470((String)attachment));
        LogUtil.debug("Query the attachment: {}", attachment);
    }

    @Override
    protected void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            TestSteppingOnBlockJob testSteppingOnBlockJob = new TestSteppingOnBlockJob();
            Managers.getScheduleManager().scheduleJob(testSteppingOnBlockJob);
        });
    }

    @Override
    protected void registerGsonTypeAdapter() {
        BaseConfigurationHandler.registerGsonTypeAdapter(CommandAttachmentNode.class, new CommandAttachmentNodeAdapter());
    }

    private static class CommandAttachmentNodeAdapter
    implements JsonDeserializer<CommandAttachmentNode> {
        private CommandAttachmentNodeAdapter() {
        }

        @Nullable
        public CommandAttachmentNode deserialize(@NotNull JsonElement json, Type typeOfT, @NotNull JsonDeserializationContext context) throws JsonParseException {
            String type;
            if (!json.getAsJsonObject().has("type")) {
                json.getAsJsonObject().addProperty("type", CommandAttackmentType.ITEMSTACK.name());
            }
            if ((type = json.getAsJsonObject().get("type").getAsString()).equals(CommandAttackmentType.ITEMSTACK.name())) {
                return (CommandAttachmentNode)context.deserialize(json, ItemStackCommandAttachmentNode.class);
            }
            if (type.equals(CommandAttackmentType.ENTITY.name())) {
                return (CommandAttachmentNode)context.deserialize(json, EntityCommandAttachmentNode.class);
            }
            if (type.equals(CommandAttackmentType.BLOCK.name())) {
                return (CommandAttachmentNode)context.deserialize(json, BlockCommandAttachmentNode.class);
            }
            throw new IllegalArgumentException("The type of command attachment entry is not supported!");
        }
    }
}

