/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_bundle;

import com.mojang.brigadier.context.CommandContext;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.processor.CommandAnnotationProcessor;
import io.github.sakurawald.fuji.core.command.structure.CommandDescriptor;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.gui.CommandsInspectionGui;
import io.github.sakurawald.fuji.core.event.impl.CommandEvents;
import io.github.sakurawald.fuji.core.event.impl.ServerLifecycleEvents;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.command_bundle.config.model.CommandBundleConfigModel;
import io.github.sakurawald.fuji.module.initializer.command_bundle.structure.BundleCommandDescriptor;
import java.util.stream.Stream;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

@Document(id=1751826356909L, value="This module allows you to create new command:\n1. The new command can accept arguments.\n2. The body of the new command, can be a list of commands.\n")
@ColorBoxes(value={@ColorBox(id=1751870454656L, color=ColorBox.ColorBlockTypes.NOTE, value="\u25c9 The features of this module:\n1. Provide a user-friendly DSL, to create `new custom commands` easily.\n2. Support the inter-operation with `user-defined variable`, `placeholders` and `target selectors`.\n3. Support complex `argument types`: `required argument`, `literal argument` and even `optional argument with a specified default value`.\n4. Pre-defined `type-system`, to use the built-in `argument type`.\n5. Register and un-register commands on the fly, without a server re-start.\n"), @ColorBox(id=1751870456781L, color=ColorBox.ColorBlockTypes.TIPS, value="\u25c9 To query all supported `argument types`:\nIssue `/fuji inspect argument-types`.\n"), @ColorBox(id=1751870458514L, color=ColorBox.ColorBlockTypes.TIPS, value="You can use command generator to get powerful commands:\nhttps://www.gamergeeks.net/apps/minecraft/particle-command-generator\n"), @ColorBox(id=1751901598337L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Combine many commands into one command.\nPattern: `composite-heal`\nBundle:\n1. `say before heal %player:name%`\n2. `run as fake-op %player:name% particle minecraft:heart ~ ~2 ~`\n3. `run as player %player:name% heal`\n4. `say after heal %player:name%`\n"), @ColorBox(id=1751901750629L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Transform the form of a command. (Can be used as a shortcut command)\nPattern: `warn \\<player player-arg\\> \\<greedy greedy-arg\\>`\nBundle:\n1. `run as player %player:name% send-message $player-arg \\<red\\>You are warned: $greedy-arg`\n"), @ColorBox(id=1751983696805L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Transform the form of a command. (List 1)\n- `/blocknbt` -> `/data get block`\n- `/entitynbt` -> `/data get entity`\n- `/gm`, `/gms` and `/gmc` -> `/gamemode`\n- `/findbiome` -> `/locate biome`\n- `/flyspeed` -> `/attribute \\<player\\> minecraft:generic.flying_speed`\n- `/walkspeed` -> `/attribute \\<player\\> minecraft:movement_speed`\n- `/maxhealth` -> `/attribute \\<player\\> minecraft:generic.max_health`\n- `/groundclean` -> `/kill @e[type=...]`\n- `/spawnmob` -> `/summon`\n- `/shoot` -> `/summon` with motion\n- `/smite` and `/thunder` -> `/summon minecraft:lighting_bolt`\n")})
@CommandNode(value="command-bundle")
@CommandRequirement(level=4)
public class CommandBundleInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<CommandBundleConfigModel> config = new ObjectConfigurationHandler<CommandBundleConfigModel>("config.json", CommandBundleConfigModel.class);

    @Document(id=1751826359683L, value="Register all commands defined in bundle-command configuration file.")
    @CommandNode(value="register")
    private static int $registerAllBundleCommands() {
        LogUtil.info("Register bundle commands.", new Object[0]);
        config.model().getEntries().stream().map(BundleCommandDescriptor::make).forEach(it -> {
            LogUtil.info("Register bundle command: {}", it.getCommandSyntax());
            it.register();
        });
        CommandHelper.updateCommandTree();
        return 1;
    }

    @Document(id=1751826362252L, value="Un-register all bundle-commands registered in server.")
    @CommandNode(value="un-register")
    private static int $unregisterAllBundleCommands() {
        LogUtil.info("Un-register bundle commands.", new Object[0]);
        CommandAnnotationProcessor.REGISTERED_COMMAND_DESCRIPTORS.stream().filter(it -> it instanceof BundleCommandDescriptor).forEach(it -> {
            LogUtil.info("Un-register bundle command: {}", it.getCommandSyntax());
            it.unregister();
        });
        CommandHelper.updateCommandTree();
        return 1;
    }

    @Document(id=1751826364625L, value="List all registered bundle-commands in server.")
    @CommandNode(value="list")
    private static int $list(@CommandSource CommandContext<class_2168> ctx) {
        Stream<CommandDescriptor> commandDescriptorStream = CommandAnnotationProcessor.REGISTERED_COMMAND_DESCRIPTORS.stream().filter(it -> it instanceof BundleCommandDescriptor);
        if (((class_2168)ctx.getSource()).method_43737()) {
            new CommandsInspectionGui(null, ((class_2168)ctx.getSource()).method_44023(), commandDescriptorStream.toList(), 0).open();
        } else {
            commandDescriptorStream.forEach(it -> ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)it.getCommandNodePath())));
        }
        return 1;
    }

    @Override
    protected void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            CommandBundleInitializer.$registerAllBundleCommands();
            CommandEvents.REGISTRATION.register((a, b, c) -> CommandBundleInitializer.$registerAllBundleCommands());
        });
    }

    @Override
    protected void onReload() {
        CommandBundleInitializer.$unregisterAllBundleCommands();
        CommandBundleInitializer.$registerAllBundleCommands();
    }
}

