/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_cooldown;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlaceholderHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.GreedyStringList;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.StringList;
import io.github.sakurawald.fuji.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.DocStringProvider;
import io.github.sakurawald.fuji.core.document.annotation.DocStringProviders;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.descriptor.PlaceholderDescriptor;
import io.github.sakurawald.fuji.core.structure.Cooldown;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.command_cooldown.command.argument.wrapper.CommandCooldownName;
import io.github.sakurawald.fuji.module.initializer.command_cooldown.config.model.CommandCooldownConfigModel;
import io.github.sakurawald.fuji.module.initializer.command_cooldown.structure.CommandCooldown;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Document(id=1751826375815L, value="This module allows you to define a `cooldown` for specified commands.\n")
@ColorBoxes(value={@ColorBox(id=1751902763633L, color=ColorBox.ColorBlockTypes.NOTE, value="\u25c9 There are 2 types of `cooldown`.\n1. `Unnamed Cooldown`: You can use it to define a cooldown time for a specified command. (The cooldown is tested and managed automatically)\n2. `Named Cooldown`: You have to use commands to create `named cooldown`, and use commands to `test it`.\n\nNOTE: If you only want to define a `cooldown` for some commands, just use `unnamed cooldown`.\n"), @ColorBox(id=1751902885278L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Create a named cooldown. (With 3 seconds cooldown)\nIssue: `/command-cooldown create example 3000`\n"), @ColorBox(id=1751903050083L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Test a named cooldown.\nIssue: `/command-cooldown test example \\<player\\> --onFailed \"say false %fuji:command_cooldown_left_time example%/%fuji:command_cooldown_left_usage example%\" say true`\n"), @ColorBox(id=1751903086020L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Reset a named cooldown for a player.\nIssue: `/command-cooldown reset example \\<player\\>`\n"), @ColorBox(id=1751903125621L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Create a named cooldown. (With 15 seconds cooldown, and 3 max usage times)\nIssue: `/command-cooldown create example 15000 --maxUsage 3`\n"), @ColorBox(id=1751903203558L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Create a named cooldown. (Global, all players shares the same cooldown instance)\nIssue: `/command-cooldown create example 3000 --global true`\n"), @ColorBox(id=1751903262817L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="By default, a `named cooldown` will be `persisted` on the `storage`.\nHowever, you can create a `non-persist named cooldown`.\nIssue: `/command-cooldown create example 999999999999 --persistent false`\nThis cooldown says that, it can be used only once after each server re-start.\n")})
@CommandNode(value="command-cooldown")
@CommandRequirement(level=4)
public class CommandCooldownInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<CommandCooldownConfigModel> config = new ObjectConfigurationHandler<CommandCooldownConfigModel>("config.json", CommandCooldownConfigModel.class){

        @Override
        public void beforeWriteStorage() {
            ((CommandCooldownConfigModel)this.model()).namedCooldown.list.values().stream().filter(it -> !it.isPersistent()).forEach(it -> it.getTimestamp().clear());
        }
    };
    private static final class_5250 NOT_COOLDOWN_FOUND_ERROR_TEXT = class_2561.method_43470((String)"NOT_COOLDOWN_FOUND_ERROR");
    private static final Map<String, Cooldown<String>> player2cooldown = new HashMap<String, Cooldown<String>>();

    public static long computeCooldown(class_3222 player, @NotNull String commandLine) {
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        Cooldown cooldown = player2cooldown.computeIfAbsent(playerName, k -> new Cooldown());
        Optional<Map.Entry> first = CommandCooldownInitializer.config.model().unnamed_cooldown.entrySet().stream().filter(it -> commandLine.matches((String)it.getKey())).findFirst();
        return first.map(entry -> cooldown.tryUse((String)entry.getKey(), (Long)entry.getValue())).orElse(-1L);
    }

    @Document(id=1751826379596L, value="Test a named-cooldown, and execute success commands or failed commands.")
    @CommandNode(value="test")
    private static int $test(@CommandSource class_2168 source, @Document(id=1751826381620L, value="The named-cooldown.") CommandCooldownName name, @Document(id=1751826385172L, value="The target player.") class_3222 player, @Document(id=1751826387810L, value="The commands to execute if the test is failed.") Optional<StringList> onFailed, @Document(id=1751826394378L, value="The commands to execute if the test is success.") GreedyStringList onSuccess) {
        CommandCooldownInitializer.ensureExist(source, name);
        CommandCooldown cooldown = CommandCooldownInitializer.config.model().namedCooldown.list.get(name.getValue());
        StringList $onFailed = onFailed.orElse(new StringList(Collections.emptyList()));
        String key = player.method_7334().getName();
        long leftTime = cooldown.tryUse(key, (Long)cooldown.getCooldownMs());
        int usage = cooldown.getUsage().getOrDefault(key, 0);
        int leftUsage = cooldown.getMaxUsage() - usage;
        if (leftTime > 0L || leftUsage <= 0) {
            CommandExecutor.execute(ExtendedCommandSource.asConsole(player.method_5671()), (List)$onFailed.getValue());
            return -1;
        }
        cooldown.getUsage().compute(key, (k, v) -> v == null ? 1 : v + 1);
        config.writeStorage();
        CommandExecutor.execute(ExtendedCommandSource.asConsole(player.method_5671()), (List)onSuccess.getValue());
        return 1;
    }

    @Document(id=1751826400837L, value="Create a named-cooldown.")
    @CommandNode(value="create")
    private static int $create(@CommandSource class_2168 source, @Document(id=1751826403270L, value="The name for named-cooldown.") String name, @Document(id=1751826405378L, value="How long is the cooling time ms of this named-cooldown.") long cooldownMs, @Document(id=1751826407322L, value="Max usage times of this named-cooldown. (per-player/global)") Optional<Integer> maxUsage, @Document(id=1751826409664L, value="Should we persist this named-cooldown on server shutdown.") Optional<Boolean> persistent, @Document(id=1751826414070L, value="Is this named-cooldown global or per-player.") Optional<Boolean> global) {
        CommandCooldownInitializer.ensureNotExist(source, name);
        int $maxUsage = maxUsage.orElse(Integer.MAX_VALUE);
        Boolean $persistent = persistent.orElse(true);
        Boolean $global = global.orElse(false);
        CommandCooldown commandCooldown = new CommandCooldown(name, cooldownMs, $maxUsage, $persistent, $global);
        CommandCooldownInitializer.config.model().namedCooldown.list.put(name, commandCooldown);
        config.writeStorage();
        TextHelper.sendTextByKey(source, "command_cooldown.created", name);
        return 1;
    }

    @Document(id=1751826416666L, value="Delete a named-cooldown.")
    @CommandNode(value="delete")
    private static int $delete(@CommandSource class_2168 source, CommandCooldownName name) {
        CommandCooldownInitializer.ensureExist(source, name);
        String key = (String)name.getValue();
        CommandCooldownInitializer.config.model().namedCooldown.list.remove(key);
        config.writeStorage();
        TextHelper.sendTextByKey(source, "command_cooldown.deleted", name.getValue());
        return 1;
    }

    @Document(id=1751826418447L, value="List all named-cooldown.")
    @CommandNode(value="list")
    private static int $list(@CommandSource class_2168 source) {
        CommandCooldownInitializer.config.model().namedCooldown.list.keySet().forEach(it -> source.method_45068((class_2561)class_2561.method_43470((String)it)));
        return 1;
    }

    @Document(id=1751826420385L, value="Reset the timestamp of a named-cooldown for a player. (The usage times will not be reset)")
    @CommandNode(value="reset")
    private static int $reset(@CommandSource class_2168 source, CommandCooldownName name, class_3222 player) {
        CommandCooldownInitializer.ensureExist(source, name);
        CommandCooldown commandCooldown = CommandCooldownInitializer.config.model().namedCooldown.list.get(name.getValue());
        config.writeStorage();
        String key = player.method_7334().getName();
        commandCooldown.getTimestamp().put(key, 0L);
        TextHelper.sendTextByKey(source, "command_cooldown.reset", key, name.getValue());
        return 1;
    }

    private static void ensureExist(class_2168 source, CommandCooldownName name) {
        if (!CommandCooldownInitializer.config.model().namedCooldown.list.containsKey(name.getValue())) {
            TextHelper.sendTextByKey(source, "command_cooldown.not_found", name.getValue());
            throw new AbortCommandExecutionException();
        }
    }

    private static void ensureNotExist(class_2168 source, String name) {
        if (CommandCooldownInitializer.config.model().namedCooldown.list.containsKey(name)) {
            TextHelper.sendTextByKey(source, "command_cooldown.already_exists", name);
            throw new AbortCommandExecutionException();
        }
    }

    @Override
    @DocStringProviders(value={@DocStringProvider(id=1751999769680L, value="Returns the `left time` for `specified named cooldown` in mill-seconds.\n"), @DocStringProvider(id=1751999791863L, value="Returns the `left usage times` for `specified named cooldown` in integer.\n")})
    protected void registerPlaceholder() {
        PlaceholderDescriptor leftTimeDescriptor = new PlaceholderDescriptor("command_cooldown_left_time", 1751999769680L);
        PlaceholderHelper.registerPlayerPlaceholder(leftTimeDescriptor, (player, args) -> {
            CommandCooldown cooldown = CommandCooldownInitializer.config.model().namedCooldown.list.get(args);
            if (cooldown == null) {
                return NOT_COOLDOWN_FOUND_ERROR_TEXT;
            }
            String key = player.method_7334().getName();
            long leftTime = cooldown.getCooldown(key, (Long)cooldown.getCooldownMs());
            leftTime = Math.max(0L, leftTime);
            return class_2561.method_43470((String)String.valueOf(leftTime));
        });
        PlaceholderDescriptor leftUsageDescriptor = new PlaceholderDescriptor("command_cooldown_left_usage", 1751999791863L);
        PlaceholderHelper.registerPlayerPlaceholder(leftUsageDescriptor, (player, args) -> {
            CommandCooldown cooldown = CommandCooldownInitializer.config.model().namedCooldown.list.get(args);
            if (cooldown == null) {
                return NOT_COOLDOWN_FOUND_ERROR_TEXT;
            }
            String key = player.method_7334().getName();
            int usage = cooldown.getUsage().getOrDefault(key, 0);
            int leftUsage = cooldown.getMaxUsage() - usage;
            return class_2561.method_43470((String)String.valueOf(leftUsage));
        });
    }
}

