/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_event;

import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.event.impl.PlayerEvents;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.command_event.config.model.CommandEventConfigModel;
import java.util.List;
import net.minecraft.class_3222;
import net.minecraft.class_3468;

@Document(id=1751826634816L, value="This module allows you to execute commands on specified events.\n")
@ColorBoxes(value={@ColorBox(id=1751904334639L, color=ColorBox.ColorBlockTypes.NOTE, value="\u25c9 How it works?\nWhen an interested event occurs, this module will execute specified commands for that event as console.\nThe `contextual player` in that `event` will be used as the `placeholder context`, to parse the `placeholders` in the `command string`.\n"), @ColorBox(id=1751904417278L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="Use the player first join event, to welcome the new-bie player.\nFor example:\n1. `send-broadcast \\<light_purple\\>Welcome new player %player:name% to join us!`\n2. `kit give %player:name% \\<kit-name\\>`\n3. `run as fake-op %player:name% rtp\"`\n4. `delay 10 spawnpoint %player:name%\"`\n")})
public class CommandEventInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<CommandEventConfigModel> config = new ObjectConfigurationHandler<CommandEventConfigModel>("config.json", CommandEventConfigModel.class);

    @Override
    protected void onInitialize() {
        PlayerEvents.ON_PLAYER_JOINED.register(CommandEventInitializer::processOnPlayerJoinedEvent);
        PlayerEvents.ON_PLAYER_LEAVE.register(CommandEventInitializer::processOnPlayerLeaveEvent);
    }

    public static void executeCommandOnEvent(class_3222 player, List<String> commands) {
        CommandExecutor.execute(ExtendedCommandSource.asConsole(player.method_5671()), commands);
    }

    private static void processOnPlayerJoinedEvent(class_3222 player) {
        CommandEventConfigModel.Event.OnPlayerJoined onPlayerJoinedConfig = CommandEventInitializer.config.model().event.on_player_joined;
        if (onPlayerJoinedConfig.enable) {
            CommandEventInitializer.executeCommandOnEvent(player, onPlayerJoinedConfig.command_list);
        }
        CommandEventConfigModel.Event.OnPlayerFirstJoined onPlayerFirstJoinedConfig = CommandEventInitializer.config.model().event.on_player_first_joined;
        if (onPlayerFirstJoinedConfig.enable && player.method_14248().method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15389)) < 1) {
            CommandEventInitializer.executeCommandOnEvent(player, onPlayerFirstJoinedConfig.command_list);
        }
    }

    private static void processOnPlayerLeaveEvent(class_3222 player) {
        CommandEventConfigModel.Event.OnPlayerLeft config = CommandEventInitializer.config.model().event.on_player_left;
        if (config.enable) {
            CommandEventInitializer.executeCommandOnEvent(player, config.command_list);
        }
    }
}

