/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_interactive;

import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import java.time.Instant;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_7450;
import net.minecraft.class_7472;
import net.minecraft.class_7635;

@Document(id=1751824965598L, value="This module allows you to write commands in `sign` block.\nAnd then click to execute commands.\n")
@ColorBoxes(value={@ColorBox(id=1751870448041L, color=ColorBox.ColorBlockTypes.TIPS, value="\u25c9 How it works?\n\nIf a player `right click` a `sign block`.\nWe will check if the `facing texts` contains the `/` character.\nIf contains, we will treat as the player issue the command.\n"), @ColorBox(id=1751968326784L, color=ColorBox.ColorBlockTypes.TIPS, value="A `sign block` that contains the `character /` is called an `interactive sign block`.\nYou can use `right click` to execute the commands written on the interactive sign block.\nYou can use `shift + right click` to edit an `interactive sign block`.\n"), @ColorBox(id=1751968409125L, color=ColorBox.ColorBlockTypes.TIPS, value="You can write some comment text before the first `character /`.\nAll 4 lines will be joined and treated as one single big line.\nSo be careful with the `space character`, and ignore the `linefeed character`.\n")})
public class CommandInteractiveInitializer
extends ModuleInitializer {
    private static final Set<class_2596<?>> TRUSTED_PACKETS = new HashSet();

    public static void addTrustedPacket(class_2596<?> packet) {
        TRUSTED_PACKETS.add(packet);
    }

    public static void removeTrustedPacket(class_2596<?> packet) {
        TRUSTED_PACKETS.remove(packet);
    }

    public static boolean isTrustedPacket(class_2596<?> packet) {
        return TRUSTED_PACKETS.contains(packet);
    }

    private static class_7472 makeCommandExecutionPacket(class_3222 player, String commandString) {
        class_7635.class_7636 ack = new class_7635.class_7636(0, new BitSet());
        class_7472 packet = new class_7472(commandString, Instant.now(), 0L, class_7450.field_39807, ack);
        return packet;
    }

    public static void mimicCommandExecutionPacket(class_3222 player, String commandString) {
        class_7472 packet = CommandInteractiveInitializer.makeCommandExecutionPacket(player, commandString);
        CommandInteractiveInitializer.addTrustedPacket(packet);
        player.field_13987.method_43667(packet);
    }
}

