/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_menu;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.command_menu.command.argument.wrapper.MenuName;
import io.github.sakurawald.fuji.module.initializer.command_menu.config.CommandMenuConfigModel;
import io.github.sakurawald.fuji.module.initializer.command_menu.config.CommandMenuMenusModel;
import io.github.sakurawald.fuji.module.initializer.command_menu.structure.MenuDescriptor;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

@Document(id=1751824895470L, value="This module allows you to define `menu` GUI, to execute commands.\n")
@ColorBoxes(value={@ColorBox(id=1751870445592L, color=ColorBox.ColorBlockTypes.NOTE, value="The `/command-menu open` command is an `admin-level` command.\nYou need to use `command_bundle` module, to creat a `user-level` command.\n"), @ColorBox(id=1751968513281L, color=ColorBox.ColorBlockTypes.TIPS, value="If you want to create a `nested menu`, you need to disable the `close menu on click` option.\nAnd handle the `menu close` using the `/command-menu close \\<player\\>` command.\n")})
@CommandNode(value="command-menu")
@CommandRequirement(level=4)
public class CommandMenuInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<CommandMenuConfigModel> config = new ObjectConfigurationHandler<CommandMenuConfigModel>("config.json", CommandMenuConfigModel.class);
    public static final BaseConfigurationHandler<CommandMenuMenusModel> menus = new ObjectConfigurationHandler<CommandMenuMenusModel>("menus.json", CommandMenuMenusModel.class);

    @Document(id=1751824900662L, value="Open the specified `menu` for the player.")
    @CommandNode(value="open")
    private static int $open(@CommandSource class_2168 source, class_3222 player, MenuName menuName) {
        String $menuName = (String)menuName.getValue();
        if (!CommandMenuInitializer.menus.model().menus.containsKey($menuName)) {
            TextHelper.getTextByKey(source, "command_menu.menu.not_found", $menuName);
            return -1;
        }
        MenuDescriptor menuDescriptor = CommandMenuInitializer.menus.model().menus.get($menuName);
        menuDescriptor.build(player).open();
        return 1;
    }

    @Document(id=1751824905935L, value="Close the currently `opened GUI` for the player.")
    @CommandNode(value="close")
    private static int $close(@CommandSource class_2168 source, class_3222 player) {
        CommandMenuInitializer.closeCurrentHandledScreen(player);
        return 1;
    }

    public static void closeCurrentHandledScreen(class_3222 player) {
        player.method_7346();
    }

    public static void executeOnSneakingAndSwapHandsCommands(class_3222 player) {
        CommandExecutor.execute(ExtendedCommandSource.asConsole(player.method_5671()), CommandMenuInitializer.config.model().onSneakingAndSwapHandsEvent.commands);
    }
}

