/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_menu.structure;

import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.module.initializer.command_menu.structure.SlotDescriptor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public class MenuDescriptor {
    @Document(id=1751824832095L, value="The `title` of this GUI.\n")
    public String title;
    @Document(id=1751824836843L, value="Ranged [1, 6]\n")
    public int lines;
    @Document(id=1751824840934L, value="Should we `close` this GUI automatically when any `slot` is `clicked`?\n\nOr you need to execute `/command-menu close <player>` command.\nTo close the GUI manually.\n")
    public boolean closeMenuOnClicked;
    public Commands commands;
    @Document(id=1751824845545L, value="Defined `slots` for this GUI.\n")
    public List<SlotDescriptor> slots;

    private class_3917<?> getScreenHandlerType() {
        if (this.lines == 1) {
            return class_3917.field_18664;
        }
        if (this.lines == 2) {
            return class_3917.field_18665;
        }
        if (this.lines == 3) {
            return class_3917.field_17326;
        }
        if (this.lines == 4) {
            return class_3917.field_18666;
        }
        if (this.lines == 5) {
            return class_3917.field_18667;
        }
        if (this.lines == 6) {
            return class_3917.field_17327;
        }
        return class_3917.field_17327;
    }

    public SimpleGui build(final class_3222 viewingPlayer) {
        SimpleGui menuGui = new SimpleGui(this.getScreenHandlerType(), viewingPlayer, false){

            public void onOpen() {
                super.onOpen();
                CommandExecutor.execute(ExtendedCommandSource.asConsole(viewingPlayer.method_5671()), MenuDescriptor.this.commands.on_open_commands);
            }

            public void onClose() {
                super.onClose();
                CommandExecutor.execute(ExtendedCommandSource.asConsole(viewingPlayer.method_5671()), MenuDescriptor.this.commands.on_closed_commands);
            }
        };
        menuGui.setTitle(TextHelper.getTextByValue(viewingPlayer, this.title, new Object[0]));
        this.slots.forEach(slotDescriptor -> {
            if (slotDescriptor.canViewThisSlot(viewingPlayer)) {
                menuGui.setSlot(slotDescriptor.index, slotDescriptor.buildGuiElement(viewingPlayer, this));
            }
        });
        return menuGui;
    }

    public String getTitle() {
        return this.title;
    }

    public int getLines() {
        return this.lines;
    }

    public boolean isCloseMenuOnClicked() {
        return this.closeMenuOnClicked;
    }

    public Commands getCommands() {
        return this.commands;
    }

    public List<SlotDescriptor> getSlots() {
        return this.slots;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setLines(int lines) {
        this.lines = lines;
    }

    public void setCloseMenuOnClicked(boolean closeMenuOnClicked) {
        this.closeMenuOnClicked = closeMenuOnClicked;
    }

    public void setCommands(Commands commands) {
        this.commands = commands;
    }

    public void setSlots(List<SlotDescriptor> slots) {
        this.slots = slots;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MenuDescriptor)) {
            return false;
        }
        MenuDescriptor other = (MenuDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLines() != other.getLines()) {
            return false;
        }
        if (this.isCloseMenuOnClicked() != other.isCloseMenuOnClicked()) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        Commands this$commands = this.getCommands();
        Commands other$commands = other.getCommands();
        if (this$commands == null ? other$commands != null : !this$commands.equals(other$commands)) {
            return false;
        }
        List<SlotDescriptor> this$slots = this.getSlots();
        List<SlotDescriptor> other$slots = other.getSlots();
        return !(this$slots == null ? other$slots != null : !((Object)this$slots).equals(other$slots));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MenuDescriptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLines();
        result = result * 59 + (this.isCloseMenuOnClicked() ? 79 : 97);
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        Commands $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : $commands.hashCode());
        List<SlotDescriptor> $slots = this.getSlots();
        result = result * 59 + ($slots == null ? 43 : ((Object)$slots).hashCode());
        return result;
    }

    public String toString() {
        return "MenuDescriptor(title=" + this.getTitle() + ", lines=" + this.getLines() + ", closeMenuOnClicked=" + this.isCloseMenuOnClicked() + ", commands=" + String.valueOf(this.getCommands()) + ", slots=" + String.valueOf(this.getSlots()) + ")";
    }

    public static class Commands {
        public List<String> on_open_commands = new ArrayList<String>();
        public List<String> on_closed_commands = new ArrayList<String>();
    }
}

