/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_menu.structure;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.document.annotation.DocStringProvider;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.descriptor.PermissionDescriptor;
import io.github.sakurawald.fuji.module.initializer.command_menu.CommandMenuInitializer;
import io.github.sakurawald.fuji.module.initializer.command_menu.structure.MenuDescriptor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1713;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlotDescriptor {
    @DocStringProvider(id=1751999474601L, value="To view this slot, you need the defined `specified permission` for this slot.\n")
    private static final PermissionDescriptor SLOT_VIEW_REQUIREMENT_PERMISSION = new PermissionDescriptor("<specified-permission>", 1751999474601L);
    @Document(id=1751824853240L, value="Where to place this item in GUI?\n")
    public int index = 0;
    @Document(id=1751824861377L, value="What is the item?\n")
    public String item = "minecraft:stone";
    @Document(id=1751824865422L, value="The count of this item.\n")
    public int count = 42;
    @Document(id=1751824870793L, value="The display name of this item.\n")
    @Nullable
    public String displayName = "<blue>My Nice Item Name";
    public boolean hideTooltip = false;
    @Document(id=1751824877459L, value="Should we glow this item?\n")
    public boolean glow = false;
    @Document(id=1751824881740L, value="The lore of this item.\n")
    public List<String> lore = new ArrayList<String>(){
        {
            this.add("<green>Hello %player:name%");
            this.add("<yellow>You are in %world:id%");
        }
    };
    @Document(id=1751824886812L, value="The `requirement` to `see` this item in GUI.\n")
    public ViewRequirement viewRequirement = new ViewRequirement();
    public Commands commands = new Commands();

    public boolean canViewThisSlot(class_3222 player) {
        if (!player.method_5687(this.viewRequirement.level)) {
            return false;
        }
        return this.viewRequirement.string == null || this.viewRequirement.string.isEmpty() || LuckpermsHelper.hasPermission(player.method_5667(), SLOT_VIEW_REQUIREMENT_PERMISSION, this.viewRequirement.string);
    }

    public GuiElementInterface buildGuiElement(class_3222 viewingPlayer, MenuDescriptor menuDescriptor) {
        GuiElementBuilder slotElementBuilder = new GuiElementBuilder();
        slotElementBuilder.setItem(RegistryHelper.ofItem(this.item));
        slotElementBuilder.setCount(this.count);
        if (this.hideTooltip) {
            GuiHelper.hideTooltip(slotElementBuilder);
        }
        if (this.glow) {
            slotElementBuilder.glow();
        }
        if (this.displayName != null) {
            class_2561 displayName = TextHelper.getTextByValue(viewingPlayer, this.displayName, new Object[0]);
            slotElementBuilder.setName(displayName);
        }
        if (this.lore != null && !this.lore.isEmpty()) {
            ArrayList lore = new ArrayList();
            this.lore.forEach(it -> lore.add(TextHelper.getTextByValue(viewingPlayer, it, new Object[0])));
            slotElementBuilder.setLore(lore);
        }
        slotElementBuilder.setCallback((GuiElementInterface.ClickCallback)new CommandMenuSlotClickCallback(viewingPlayer, menuDescriptor, this));
        return slotElementBuilder.build();
    }

    public int getIndex() {
        return this.index;
    }

    public String getItem() {
        return this.item;
    }

    public int getCount() {
        return this.count;
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isHideTooltip() {
        return this.hideTooltip;
    }

    public boolean isGlow() {
        return this.glow;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public ViewRequirement getViewRequirement() {
        return this.viewRequirement;
    }

    public Commands getCommands() {
        return this.commands;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setItem(String item) {
        this.item = item;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
    }

    public void setHideTooltip(boolean hideTooltip) {
        this.hideTooltip = hideTooltip;
    }

    public void setGlow(boolean glow) {
        this.glow = glow;
    }

    public void setLore(List<String> lore) {
        this.lore = lore;
    }

    public void setViewRequirement(ViewRequirement viewRequirement) {
        this.viewRequirement = viewRequirement;
    }

    public void setCommands(Commands commands) {
        this.commands = commands;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SlotDescriptor)) {
            return false;
        }
        SlotDescriptor other = (SlotDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        if (this.isHideTooltip() != other.isHideTooltip()) {
            return false;
        }
        if (this.isGlow() != other.isGlow()) {
            return false;
        }
        String this$item = this.getItem();
        String other$item = other.getItem();
        if (this$item == null ? other$item != null : !this$item.equals(other$item)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        List<String> this$lore = this.getLore();
        List<String> other$lore = other.getLore();
        if (this$lore == null ? other$lore != null : !((Object)this$lore).equals(other$lore)) {
            return false;
        }
        ViewRequirement this$viewRequirement = this.getViewRequirement();
        ViewRequirement other$viewRequirement = other.getViewRequirement();
        if (this$viewRequirement == null ? other$viewRequirement != null : !this$viewRequirement.equals(other$viewRequirement)) {
            return false;
        }
        Commands this$commands = this.getCommands();
        Commands other$commands = other.getCommands();
        return !(this$commands == null ? other$commands != null : !this$commands.equals(other$commands));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SlotDescriptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        result = result * 59 + this.getCount();
        result = result * 59 + (this.isHideTooltip() ? 79 : 97);
        result = result * 59 + (this.isGlow() ? 79 : 97);
        String $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : $item.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        List<String> $lore = this.getLore();
        result = result * 59 + ($lore == null ? 43 : ((Object)$lore).hashCode());
        ViewRequirement $viewRequirement = this.getViewRequirement();
        result = result * 59 + ($viewRequirement == null ? 43 : $viewRequirement.hashCode());
        Commands $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : $commands.hashCode());
        return result;
    }

    public String toString() {
        return "SlotDescriptor(index=" + this.getIndex() + ", item=" + this.getItem() + ", count=" + this.getCount() + ", displayName=" + this.getDisplayName() + ", hideTooltip=" + this.isHideTooltip() + ", glow=" + this.isGlow() + ", lore=" + String.valueOf(this.getLore()) + ", viewRequirement=" + String.valueOf(this.getViewRequirement()) + ", commands=" + String.valueOf(this.getCommands()) + ")";
    }

    public static class ViewRequirement {
        public int level = 0;
        @Nullable
        public String string = null;
    }

    public record CommandMenuSlotClickCallback(class_3222 viewingPlayer, MenuDescriptor menuDescriptor, SlotDescriptor slotDescriptor) implements GuiElementInterface.ClickCallback
    {
        public void click(int i, ClickType clickType, class_1713 clickType1, @NotNull SlotGuiInterface slotGuiInterface) {
            if (clickType == ClickType.MOUSE_LEFT && !this.slotDescriptor.commands.on_left_click_commands.isEmpty()) {
                CommandExecutor.execute(ExtendedCommandSource.asConsole(this.viewingPlayer.method_5671()), this.slotDescriptor.commands.on_left_click_commands);
                this.tryCloseThisMenu();
                return;
            }
            if (clickType == ClickType.MOUSE_RIGHT && !this.slotDescriptor.commands.on_right_click_commands.isEmpty()) {
                CommandExecutor.execute(ExtendedCommandSource.asConsole(this.viewingPlayer.method_5671()), this.slotDescriptor.commands.on_right_click_commands);
                this.tryCloseThisMenu();
                return;
            }
            if (clickType == ClickType.MOUSE_LEFT_SHIFT && !this.slotDescriptor.commands.on_left_shift_click_commands.isEmpty()) {
                CommandExecutor.execute(ExtendedCommandSource.asConsole(this.viewingPlayer.method_5671()), this.slotDescriptor.commands.on_left_shift_click_commands);
                this.tryCloseThisMenu();
                return;
            }
            if (clickType == ClickType.MOUSE_RIGHT_SHIFT && !this.slotDescriptor.commands.on_right_shift_click_commands.isEmpty()) {
                CommandExecutor.execute(ExtendedCommandSource.asConsole(this.viewingPlayer.method_5671()), this.slotDescriptor.commands.on_right_shift_click_commands);
                this.tryCloseThisMenu();
                return;
            }
            if (clickType == ClickType.MOUSE_MIDDLE && !this.slotDescriptor.commands.on_middle_click_commands.isEmpty()) {
                CommandExecutor.execute(ExtendedCommandSource.asConsole(this.viewingPlayer.method_5671()), this.slotDescriptor.commands.on_middle_click_commands);
                this.tryCloseThisMenu();
                return;
            }
        }

        private void tryCloseThisMenu() {
            if (this.menuDescriptor.closeMenuOnClicked) {
                CommandMenuInitializer.closeCurrentHandledScreen(this.viewingPlayer);
            }
        }
    }

    public static class Commands {
        public List<String> on_left_click_commands = new ArrayList<String>(){
            {
                this.add("send-message %player:name% You just clicked me.");
                this.add("chain has-level? %player:name% 4 chain send-message %player:name% <yellow>You are op player.");
                this.add("command-menu close %player:name%");
            }
        };
        public List<String> on_left_shift_click_commands = new ArrayList<String>();
        public List<String> on_right_click_commands = new ArrayList<String>();
        public List<String> on_right_shift_click_commands = new ArrayList<String>();
        public List<String> on_middle_click_commands = new ArrayList<String>();
    }
}

