/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_meta.chain;

import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2168;

@Document(id=1751824730196L, value="Provides `/chain` command.\nIt allows you to run another 2 commands.\nThe first command is `any command`.\nThe second command is `the chain command`.\n")
@ColorBoxes(value={@ColorBox(id=1751870431402L, color=ColorBox.ColorBlockTypes.NOTE, value="In vanilla Minecraft, the return value of a command, is a `integer`.\nIf integer less than zero, it's `failed`.\nIf integer equals zero, it's `passed`.\nIf integer grater than zero, it's `success`.\n"), @ColorBox(id=1751969034903L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 A nested chain\nIssue: `/chain say 1 chain say 2 chain say 3`\n\n\u25c9 A breakable chain\nIssue: `/chain bad command here chain say 2`\n\n\u25c9 Use chain command with predicate command\nIssue: `/run as player \\<player\\> chain test-level-perm %player:name% 4 chain say value is true`\n")})
public class ChainInitializer
extends ModuleInitializer {
    private static final Pattern CHAIN_COMMAND_PARSER = Pattern.compile("(.+?)\\s+(chain .+)");

    @Document(id=1751824736793L, value="Chain commands and executes them in sequence, the chain will break if the previous one command fails.")
    @CommandNode(value="chain")
    @CommandRequirement(level=4)
    private static int $chain(@CommandSource class_2168 source, GreedyString rest) {
        String $rest = (String)rest.getValue();
        Matcher matcher = CHAIN_COMMAND_PARSER.matcher($rest);
        if (matcher.find()) {
            String first = matcher.group(1);
            String second = matcher.group(2);
            int value = CommandExecutor.execute(ExtendedCommandSource.fromSource(source), first);
            if (value >= 0) {
                CommandExecutor.execute(ExtendedCommandSource.fromSource(source), second);
            }
        } else {
            CommandExecutor.execute(ExtendedCommandSource.fromSource(source), $rest);
        }
        return 1;
    }
}

