/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_meta.run;

import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

@Document(id=1751823988812L, value="Provides `/run` command, to run a command with context.\n")
@ColorBoxes(value={@ColorBox(id=1751968631536L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Give random amount of diamonds to online players.\nIssue: `/run as console give @a minecraft:diamond %fuji:random 8 32%`\n"), @ColorBox(id=1751968672241L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Give online players random amount of diamonds.\nIssue: `/run as console foreach give %fuji:escape player:name% minecraft:diamond %fuji:escape fuji:random 8 32 1%`\n"), @ColorBox(id=1751968707088L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Execute a command as a specified player.\nIssue: `/run as player \\<player\\> back`\n"), @ColorBox(id=1751968753602L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Execute a command as a fake-op.\nIssue: `/run as fake-op \\<player\\> give %player:name% minecraft:apple 1`\n")})
@CommandNode(value="run")
@CommandRequirement(level=4)
public class RunInitializer
extends ModuleInitializer {
    @Document(id=1751823993461L, value="Execute a command as console.")
    @CommandNode(value="as console")
    private static int $runAsConsole(@CommandSource class_2168 source, GreedyString rest) {
        CommandExecutor.execute(ExtendedCommandSource.asConsole(source), (String)rest.getValue());
        return 1;
    }

    @Document(id=1751823999061L, value="Execute a command as a player.")
    @CommandNode(value="as player")
    private static int $runAsPlayer(@CommandSource class_2168 source, class_3222 player, GreedyString rest) {
        return CommandExecutor.execute(ExtendedCommandSource.asPlayer(source, player), (String)rest.getValue());
    }

    @Document(id=1751824003937L, value="Execute a command as a player with fake-op.")
    @CommandNode(value="as fake-op")
    private static int $runAsFakeOp(@CommandSource class_2168 source, class_3222 player, GreedyString rest) {
        return CommandExecutor.execute(ExtendedCommandSource.asFakeOp(source, player), (String)rest.getValue());
    }
}

