/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_meta.when_online;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.OfflinePlayerName;
import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.event.impl.PlayerEvents;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.command_meta.when_online.config.model.WhenOnlineDataModel;
import io.github.sakurawald.fuji.module.initializer.command_meta.when_online.gui.ListWhenOnlineTicketsGui;
import io.github.sakurawald.fuji.module.initializer.command_meta.when_online.structure.WhenOnlineTicket;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

@Document(id=1751824024333L, value="This module provides the `/when-online \\<player\\> \\<cmd\\>` command.\nTo execute a specified command `exactly once` when the target player is `online`:\n1. If the target player is `online` now, the command will be executed `at once`.\n2. If the target player is `offline` now, the command will be executed `when the player online`.\n\nBesides, you use `/when-online list` to manage `submitted commands`.\n\nFor example:\n1. `/when-online Steve give %player:name% minecraft:apple 3`\n2. `/when-online Alex delay 8 say Hi %player:name%`\n")
public class WhenOnlineInitializer
extends ModuleInitializer {
    public static BaseConfigurationHandler<WhenOnlineDataModel> data = new ObjectConfigurationHandler<WhenOnlineDataModel>("when-online-data.json", WhenOnlineDataModel.class);

    @CommandNode(value="when-online")
    @CommandRequirement(level=4)
    private static int $whenOnline(@CommandSource class_2168 source, OfflinePlayerName targetPlayer, GreedyString command) {
        String $creatorName = source.method_9214();
        String $targetPlayerName = (String)targetPlayer.getValue();
        String $command = (String)command.getValue();
        WhenOnlineTicket ticket = WhenOnlineTicket.make($creatorName, $targetPlayerName, $command);
        WhenOnlineInitializer.data.model().tickets.add(ticket);
        data.writeStorage();
        WhenOnlineInitializer.processWhenOnlineTickets();
        return 1;
    }

    @CommandNode(value="when-online list")
    @CommandRequirement(level=4)
    private static int $list(@CommandSource class_3222 player) {
        ListWhenOnlineTicketsGui.make(player).open();
        return 1;
    }

    @Override
    protected void onInitialize() {
        PlayerEvents.ON_PLAYER_JOINED.register(p -> WhenOnlineInitializer.processWhenOnlineTickets());
    }

    private static void processWhenOnlineTickets() {
        List<String> onlinePlayerNames = ServerHelper.getOnlinePlayerNames();
        WhenOnlineInitializer.data.model().tickets.stream().toList().stream().filter(ticket -> ticket.executedTimestamp == null && onlinePlayerNames.contains(ticket.targetPlayer)).forEach(ticket -> {
            LogUtil.debug("Execute the ticket: {}", ticket);
            ticket.executedTimestamp = System.currentTimeMillis();
            class_3222 onlinePlayer = ServerHelper.getOnlinePlayerByName(ticket.targetPlayer);
            ExtendedCommandSource extendedCommandSource = ExtendedCommandSource.asConsole(onlinePlayer.method_5671());
            String commandString = ticket.command;
            CommandExecutor.execute(extendedCommandSource, commandString);
        });
        data.writeStorage();
    }
}

