/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_permission;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.Cite;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.DocStringProvider;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.descriptor.PermissionDescriptor;
import io.github.sakurawald.fuji.core.event.impl.ServerLifecycleEvents;
import io.github.sakurawald.fuji.core.structure.CommandNodeWrapper;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.command_permission.config.model.CommandPermissionConfigModel;
import io.github.sakurawald.fuji.module.initializer.command_permission.gui.CommandPermissionGui;
import io.github.sakurawald.fuji.module.initializer.command_permission.structure.CommandNodePermissionWrapper;
import io.github.sakurawald.fuji.module.initializer.command_permission.structure.CommandPermissionRule;
import io.github.sakurawald.fuji.module.initializer.command_permission.structure.WrappedPredicate;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.luckperms.api.util.Tristate;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Cite(value={"https://github.com/DrexHD/VanillaPermissions"})
@Document(id=1751826772214L, value="This module provides the `luckperms permissions` for `all commands`.\n")
@ColorBoxes(value={@ColorBox(id=1751970566759L, color=ColorBox.ColorBlockTypes.NOTE, value="\u25c9 How it works?\nThe vanilla Minecraft use a command system, named `brigadier command system`.\nAll `commands` are `registered`, `parsed` and `executed` by this system.\nIn the design of this command system, all commands are built into a `tree structure`.\nThat is the `command tree`.\nAll commands starts with the `root command`, and walking down the `path` of the `command tree`.\nAll commands are a `direct child` or `in-direct child` of the `root command node`.\nBased on these facts, we can `identify` a `command node` using its `path` in the `command tree`.\n\nFor example, the command string `/gamemode creative Steve`.\nCan be parsed into command nodes: `gamemode`, `creative` and `Steve`.\nAnd its `command path` is `gamemode.gamemode.target`.\n\nYou can issue `/command-permission describe gamemode creative Steve` to see what is happening.\nTo see the `tree structure` of this command node, issue `/help gamemode` command.\n\nTo open the command permission GUI, issue `/command-permission gui` command.\nTo list all commands and their command path, issue `/fuji inspect server-commands` command.\n"), @ColorBox(id=1751970931219L, color=ColorBox.ColorBlockTypes.NOTE, value="Let's continue, the `brigadier command system`, organize all `command nodes` into a `tree structure`.\nAnd for each `command node`, there is a `requirement` option, it's a `predicate`, to decide whether the `command source` can use this `command node`.\n\nThat's the core part.\nThe `command_permission` module, will walk down the entire `command tree`.\nAnd `wrap` the `requirement` option for each `command node`.\nAnd then, we can assign a `luckperms permission` for each `command node`.\nThat's because, we can `identify` a `command node` using its `command path` in the `command tree`.\n\nIssue: `/command-permission describe gamemode creative Steve` to see how it works.\n"), @ColorBox(id=1751971202478L, color=ColorBox.ColorBlockTypes.NOTE, value="\u25c9 How does `command_permission` module handles the `inheritance permission`, `wildcard permission` and `regex permission`?\n\nActually, the `command_permission` module didn't handle them.\nThe module only does one simple thing: Let's check if the command source has the corresponding luckperms permission `fuji.permission.\\<command path of that target command\\>`.\nThe complex things like `inheritance permission`, `wildcard permission` and `regex permission` are all processed by `luckperms` mod.\nYeah, the `luckperms` mod does the complex `permission calculation`.\n"), @ColorBox(id=1751971384898L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Allow everyone to use `/gamemode` command.\nYou can issue `/lp group default permission set fuji.permission.gamemode true`\n\nNOTE: If you want to allow the client-side to use the gamemode switcher menu, you have to install extra mods in the client-side, to let the client-side believe they are `op`, and they can switch the gamemode.\nThe mod can be https://modrinth.com/mod/switcher\n"), @ColorBox(id=1751971538425L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Allow everyone to use `/gamemode` command, except the player Alice.\nIssue the commands:\n1. `/lp group default permission set fuji.permission.gamemode true`\n2. `/lp user Alice permission set fuji.permission.gamemode false`\n"), @ColorBox(id=1751971597924L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Allow everyone to use `/gamemode spectator`, but disallows the `/gamemode creative`.\nYou have touch the core, and the tricky things.\nNow, issue `/command-permission describe gamemode spectator` command.\nYou will find that, the second command node `creative` is actually `an argument`.\nIts `argument` whose argument type is `gamemode`, and accepts the possible values `adventure`, `creative`, `spectator` and `survival`.\nAll 4 gamemodes are possible values for `gamemode argument type`.\nThat's the reason why you can't just ban the `creative` gamemode.\n\nIf you really want to allow the user to use `/gamemode spectator`, and ban the `/gamemode creative`.\nYou can use `command_bundle` to create a `user-level` command, to wrap the `/gamemode` command.\nLike, create a new command named `/switch-to-survival`, as a wrapper command for `/gamemode` command.\n"), @ColorBox(id=1751990106002L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Allow players to use `/seed` command.\nThe `/seed` command provided by Mojang, requires `level permission` to be `3` to use.\nIf you want to `allow` players to use `/seed` command, but you don't want to grant `op` for them.\nThen, you can `set` a `positive string permission` for them.\nIssue `/lp group default permission set fuji.permission.seed true`.\nIt says `allow` the players to use `/seed` command.\n\nIssue `/command-permission describe seed` command, to see how it works.\n"), @ColorBox(id=1751990203999L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Dis-allow players to use `/list` command.\nThe `/list` command provided by Mojang, requires `level permission` to be `0` to use.\nIf you want to `dis-allow` players to use `/list` command.\nBut because this command requires no string permission to use.\nSo it's impossible to ban it via `luckperms` mod.\n\nIn this case, you `can` set a `negative string permission` for them.\nIssue `/lp group default permission set fuji.permission.list false`.\nIt says `dis-allow` the players to use `/list` command.\n\nIssue `/command-permission describe list` command, to see how it works.\n"), @ColorBox(id=1751990343803L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Unset the override of requirement of a specific command.\nTo `undo` the operation in the `/seed` example.\nYou can `unset` the assigned permission before.\nIssue `/lp group default permission unset fuji.permission.seed` command, to unset the assign permission.\n"), @ColorBox(id=1751990466823L, color=ColorBox.ColorBlockTypes.TIPS, value="\u25c9 Advanced Usage\nThe `luckperms` mod have a feature named `permission context`.\nWhich allows you to specify the `per-dimension permission` and `temporary permission`.\nIf you are interested, see the details in their official wiki.\n")})
@io.github.sakurawald.fuji.core.command.annotation.CommandNode(value="command-permission")
@CommandRequirement(level=4)
public class CommandPermissionInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<CommandPermissionConfigModel> config = new ObjectConfigurationHandler<CommandPermissionConfigModel>("config.json", CommandPermissionConfigModel.class);
    private static boolean verboseModeFlag = false;
    @DocStringProvider(id=1752000303860L, value="To use the `command` with that `command path`.\nYou need the corresponding permission.\n\nIssue `/command-permission describe` to see details.\n1. `/command-permission describe fly`\n2. `/command-permission describe fly others @r`\n")
    public static final PermissionDescriptor COMMAND_PERMISSION_UNIFIED_PERMISSION = new PermissionDescriptor("fuji.permission.<command-path>", 1752000303860L);

    @io.github.sakurawald.fuji.core.command.annotation.CommandNode(value="gui")
    @Document(id=1751826777672L, value="Open the command permission gui.")
    public static int $gui(@CommandSource class_3222 player) {
        List<CommandNodePermissionWrapper> entities = CommandHelper.getCommandNodes().stream().map(CommandNodePermissionWrapper::new).sorted(Comparator.comparing(CommandNodeWrapper::getPath)).toList();
        new CommandPermissionGui(player, entities, 0).open();
        return 1;
    }

    @Document(id=1751826779531L, value="Toggle the command permission verbose mode.")
    @io.github.sakurawald.fuji.core.command.annotation.CommandNode(value="verbose")
    public static int $verbose(@CommandSource class_2168 source) {
        verboseModeFlag = !verboseModeFlag;
        TextHelper.sendTextByKey(source, verboseModeFlag ? "command_permission.verbose.on" : "command_permission.verbose.off", new Object[0]);
        return 1;
    }

    @Document(id=1751826781243L, value="Describe the `required permissions` of `the given command`.")
    @io.github.sakurawald.fuji.core.command.annotation.CommandNode(value="describe")
    public static int $describe(@CommandSource class_2168 source, GreedyString command) {
        String $command = (String)command.getValue();
        ParseResults parseResults = ServerHelper.getCommandDispatcher().parse($command, (Object)source);
        CommandContextBuilder context = parseResults.getContext();
        String commandString = TextHelper.Parsers.escapeTags(parseResults.getReader().getString());
        TextHelper.sendTextByKey(source, "command_permission.describe.command_string", commandString);
        @Nullable CommandSyntaxException earlyException = class_2170.method_23917((ParseResults)parseResults);
        if (earlyException != null) {
            TextHelper.sendTextByKey(source, "command_permission.describe.command_string.parser.exceptions", new Object[0]);
            TextHelper.sendTextByKey(source, "command_permission.describe.command_string.parser.early_exception", new Object[]{earlyException});
            return 1;
        }
        Map exceptions = parseResults.getExceptions();
        if (!exceptions.isEmpty()) {
            TextHelper.sendTextByKey(source, "command_permission.describe.command_string.parser.exceptions", new Object[0]);
            exceptions.forEach((k, v) -> {
                String nodeName = k.getName();
                String exception = v.toString();
                TextHelper.sendTextByKey(source, "command_permission.describe.command_string.parser.exception", nodeName, exception);
            });
            return 1;
        }
        List nodes = context.getNodes();
        List<String> nodesName = nodes.stream().map(it -> it.getNode().getName()).toList();
        TextHelper.sendTextByKey(source, "command_permission.describe.command_node.nodes", nodesName);
        if (nodesName.isEmpty()) {
            TextHelper.sendTextByKey(source, "command_permission.describe.command_node.empty", new Object[0]);
            return 1;
        }
        nodes.forEach(it -> {
            CommandNode node = it.getNode();
            String nodeName = node.getName();
            String nodeType = CommandHelper.getCommandNodeType((CommandNode<class_2168>)node);
            boolean nodeWrapped = CommandPermissionInitializer.isCommandNodeWrapped((CommandNode<class_2168>)node);
            TextHelper.sendTextByKey(source, "command_permission.describe.command_node.node", nodeName, nodeType, nodeWrapped);
        });
        String commandPath = CommandHelper.joinCommandNodePath(context.getNodes());
        TextHelper.sendTextByKey(source, "command_permission.describe.command_path", commandPath);
        TextHelper.sendTextByKey(source, "command_permission.describe.command_permissions", new Object[0]);
        List<String> commandPathPrefixes = CommandHelper.getPrefixesOfCommandPath(nodes);
        commandPathPrefixes.forEach(path -> {
            String requiredPermission = COMMAND_PERMISSION_UNIFIED_PERMISSION.withArguments(path);
            TextHelper.sendTextByKey(source, "command_permission.describe.command_permission", requiredPermission);
        });
        source.method_45068((class_2561)class_2561.method_43473());
        return 1;
    }

    private static void processVerboseModeFeature(String askWhoForPermissionTestResult, class_2168 source, String commandPath, Tristate commandPermissionTestResult) {
        if (!verboseModeFlag) {
            return;
        }
        String explanationForPermissionTestResult = CommandPermissionInitializer.makeExplanationForPermissionTestResult(commandPermissionTestResult);
        LogUtil.info("\n\u25c9 Command Source: {}\n\u25c9 Command Path of the Target Command: {}\n\u25c9 Ask who for permission test result: {}\n\u25c9 Permission Test Result: {}\n\u25c9 Explanation: {}\n", source.method_9214(), commandPath, askWhoForPermissionTestResult, commandPermissionTestResult, explanationForPermissionTestResult);
    }

    @NotNull
    private static String makeExplanationForPermissionTestResult(Tristate state) {
        String explanation = state == Tristate.UNDEFINED ? "The permission test result is UNDEFINED, it means command_permission module WILL NOT HANDLE this command. We simply fallback the requirement predicate of this command to its original predicate." : (state == Tristate.TRUE ? "The permission test result is TRUE, it means command_permission module WILL ALLOW the command source to use this command." : (state == Tristate.FALSE ? "The permission test result is FALSE, it means command_permission module WILL DIS-ALLOW the command source to use this command." : "I don't know why, but the value of Tristate is un-expected."));
        return explanation;
    }

    @NotNull
    public static WrappedPredicate<class_2168> makeWrappedPredicate(String commandPath, @NotNull Predicate<class_2168> originalRequirement) {
        return source -> {
            if (source.method_44023() == null) {
                return originalRequirement.test((class_2168)source);
            }
            try {
                String requiredPermissionToExecuteThisCommand = COMMAND_PERMISSION_UNIFIED_PERMISSION.withArguments(commandPath);
                if (!PlayerHelper.isAdmin(source)) {
                    for (CommandPermissionRule rule : CommandPermissionInitializer.config.model().rules) {
                        if (!requiredPermissionToExecuteThisCommand.matches(rule.permissionPatternRegex)) continue;
                        Tristate predefinePermissionTestResult = rule.permissionTestResult.toTriState();
                        CommandPermissionInitializer.processVerboseModeFeature("PREDEFINED RULES", source, commandPath, predefinePermissionTestResult);
                        return CommandPermissionInitializer.canUseThisCommand(source, predefinePermissionTestResult, originalRequirement);
                    }
                }
                Tristate luckpermsPermissionTestResult = LuckpermsHelper.getPermission(source.method_44023().method_5667(), COMMAND_PERMISSION_UNIFIED_PERMISSION, commandPath);
                CommandPermissionInitializer.processVerboseModeFeature("LUCKPERMS", source, commandPath, luckpermsPermissionTestResult);
                return CommandPermissionInitializer.canUseThisCommand(source, luckpermsPermissionTestResult, originalRequirement);
            }
            catch (Throwable useOriginalPredicateIfFailed) {
                return originalRequirement.test((class_2168)source);
            }
        };
    }

    private static boolean canUseThisCommand(class_2168 source, Tristate permissionTestResult, @NotNull Predicate<class_2168> originalRequirement) {
        if (permissionTestResult != Tristate.UNDEFINED) {
            return permissionTestResult.asBoolean();
        }
        return originalRequirement.test(source);
    }

    private static void ensureCommandNodeRequirementIsWrapped() {
        CommandHelper.getCommandNodes().forEach(CommandNode::getRequirement);
    }

    public static boolean isCommandNodeWrapped(CommandNode<class_2168> commandNode) {
        return commandNode.getRequirement() instanceof WrappedPredicate;
    }

    @Override
    protected void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> CommandPermissionInitializer.ensureCommandNodeRequirementIsWrapped());
    }
}

