/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_scheduler;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.manager.Managers;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.command_scheduler.command.argument.wrapper.JobName;
import io.github.sakurawald.fuji.module.initializer.command_scheduler.config.model.CommandSchedulerConfigModel;
import io.github.sakurawald.fuji.module.initializer.command_scheduler.gui.JobGui;
import io.github.sakurawald.fuji.module.initializer.command_scheduler.job.CommandScheduleJob;
import io.github.sakurawald.fuji.module.initializer.command_scheduler.structure.Job;
import java.util.List;
import net.minecraft.class_3222;
import org.quartz.JobDataMap;

@Document(id=1751826754641L, value="This module allows you to define `jobs` using `cron` language.\nTo execute commands at schedule.\n")
@ColorBoxes(value={@ColorBox(id=1751870574475L, color=ColorBox.ColorBlockTypes.NOTE, value="\u25c9 How it works?\n\nA `job` is used to execute commands periodically.\nWe use `cron` language to define when the `job` should be `triggered`.\n"), @ColorBox(id=1751972254866L, color=ColorBox.ColorBlockTypes.TIPS, value="\u25c9 You can use `cron expression` generator, to specify when the job should be triggered.\nSee https://www.freeformatter.com/cron-expression-generator-quartz.html\n\nIssue `/fuji inspect jobs` to see the `fire dates` of defined `jobs`.\n")})
@CommandNode(value="command-scheduler")
@CommandRequirement(level=4)
public class CommandSchedulerInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<CommandSchedulerConfigModel> scheduler = new ObjectConfigurationHandler<CommandSchedulerConfigModel>("scheduler.json", CommandSchedulerConfigModel.class);

    @Override
    protected void onInitialize() {
        this.reloadJobs();
    }

    @Override
    protected void onReload() {
        this.reloadJobs();
    }

    @Document(id=1751826757048L, value="List all defined jobs.")
    @CommandNode(value="list")
    private static int $list(@CommandSource class_3222 player) {
        List<Job> jobs = CommandSchedulerInitializer.scheduler.model().jobs;
        new JobGui(player, jobs, 0).open();
        return 1;
    }

    @Document(id=1751826758887L, value="Trigger a job manually.")
    @CommandNode(value="trigger")
    private static int $trigger(JobName jobName) {
        CommandSchedulerInitializer.scheduler.model().jobs.stream().filter(it -> it.getName().equals(jobName.getValue())).findFirst().ifPresent(Job::tryTrigger);
        return 1;
    }

    private void reloadJobs() {
        LogUtil.info("Un-schedule jobs.", new Object[0]);
        Managers.getScheduleManager().deleteJobs(CommandScheduleJob.class);
        CommandSchedulerInitializer.scheduler.model().jobs.forEach(definedJob -> {
            definedJob.getCrons().forEach(cron -> {
                CommandScheduleJob job = new CommandScheduleJob(definedJob.getName(), new JobDataMap((Job)definedJob){
                    final /* synthetic */ Job val$definedJob;
                    {
                        this.val$definedJob = val$definedJob;
                        this.put("job", this.val$definedJob);
                    }
                }, () -> cron);
                Managers.getScheduleManager().scheduleJob(job);
            });
            LogUtil.info("Schedule job -> {}", definedJob.getName());
        });
    }
}

