/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_toolbox.tppos;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.EntityHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.WorldHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.annotation.CommandTarget;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.Dimension;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.OfflinePlayerName;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.PlayerCollection;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.service.random_teleport.RandomTeleporter;
import io.github.sakurawald.fuji.core.structure.GlobalPos;
import io.github.sakurawald.fuji.core.structure.TeleportSetup;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

@Document(id=1751825242047L, value="Provides `/tppos` command.\nA `unified` and `powerful` teleport command.\n\nFor example:\n1. `/tppos --z 64 --x 32 --y 128` to teleport to `a specified position`\n2. `/tppos --others Steve` to specify the `target player`.\n3. `/tppos offline Alex` to teleport to the `offline position of Alex`.\n4. `/tppos --dimension` to specify the `target dimension`, and start `a random tp`.\n5. `/tppos --minRange 1000 --maxRange 2000` to specify the setup for `a random tp`.\n6. `/tppos here @a` to teleport `all online players` to `you`.\n")
public class TpposInitializer
extends ModuleInitializer {
    @Document(id=1751825250986L, value="The unified teleport command.")
    @CommandNode(value="tppos")
    @CommandRequirement(level=4)
    private static int $tppos(@CommandSource @CommandTarget class_3222 player, @Document(id=1751825286136L, value="the target dimension") Optional<Dimension> dimension, @Document(id=1751825291728L, value="the target x for fixed-tp") Optional<Double> x, @Document(id=1751825295183L, value="the target y for fixed-tp") Optional<Double> y, @Document(id=1751825298686L, value="the target z for fixed-tp") Optional<Double> z, @Document(id=1751825302162L, value="the target yaw for fixed-tp") Optional<Float> yaw, @Document(id=1751825308511L, value="the target pitch for fixed-tp") Optional<Float> pitch, @Document(id=1751825312187L, value="center x for rtp") Optional<Integer> centerX, @Document(id=1751825318126L, value="center z for rtp") Optional<Integer> centerZ, @Document(id=1751825322575L, value="is the shape of rtp circle or square") Optional<Boolean> circle, @Document(id=1751825327440L, value="min radius for rtp") Optional<Integer> minRange, @Document(id=1751825331634L, value="max radius for rtp") Optional<Integer> maxRange, @Document(id=1751825335795L, value="min y for rtp") Optional<Integer> minY, @Document(id=1751825340303L, value="max y for rtp") Optional<Integer> maxY, @Document(id=1751825344683L, value="max try times for rtp") Optional<Integer> maxTryTimes) {
        class_3218 world;
        class_3218 class_32182 = world = dimension.isPresent() ? (class_3218)dimension.get().getValue() : EntityHelper.getServerWorld((class_1297)player);
        if (x.isPresent() || y.isPresent() || z.isPresent()) {
            double $x = x.orElse(player.method_23317());
            double $y = y.orElse(player.method_23318());
            double $z = z.orElse(player.method_23321());
            float $yaw = yaw.orElse(Float.valueOf(player.method_36454())).floatValue();
            float $pitch = pitch.orElse(Float.valueOf(player.method_36455())).floatValue();
            GlobalPos globalPos = new GlobalPos((class_1937)world, $x, $y, $z, $yaw, $pitch);
            globalPos.teleport(player);
            return 1;
        }
        int $centerX = centerX.orElse((int)world.method_8621().method_11964());
        int $centerZ = centerZ.orElse((int)world.method_8621().method_11980());
        boolean $circle = circle.orElse(false);
        int $minRange = minRange.orElse(0);
        int $maxRange = maxRange.orElse((int)world.method_8621().method_11965() / 2);
        int $minY = minY.orElse(world.method_31607());
        int $maxY = maxY.orElse(WorldHelper.getTopY((class_1937)world));
        int $maxTryTimes = maxTryTimes.orElse(8);
        TeleportSetup teleportSetup = new TeleportSetup(RegistryHelper.toString((class_1937)world), $centerX, $centerZ, $circle, $minRange, $maxRange, $minY, $maxY, $maxTryTimes);
        RandomTeleporter.request(player, teleportSetup, null);
        return 1;
    }

    @Document(id=1751825355777L, value="Teleport to the offline position of a player.")
    @CommandNode(value="tppos offline")
    @CommandRequirement(level=4)
    private static int $tppos(@CommandSource class_3222 source, OfflinePlayerName player) {
        class_3222 dummy = PlayerHelper.loadOfflinePlayer((String)player.getValue());
        new GlobalPos((class_1937)EntityHelper.getServerWorld((class_1297)dummy), dummy.method_23317(), dummy.method_23318(), dummy.method_23321(), dummy.method_36454(), dummy.method_36455()).teleport(source);
        return 1;
    }

    @Document(id=1751825360963L, value="Teleport `others` to `you`.\n\nFor example:\n1. `/tppos here Steve` to teleport `Steve` to `you`.\n2. `/tppos here @a` to teleport `all online players` to `you`.\n")
    @CommandNode(value="tppos here")
    @CommandRequirement(level=4)
    private static int $tppos(@CommandSource class_3222 source, PlayerCollection targets) {
        Collection $targets = (Collection)targets.getValue();
        GlobalPos globalPos = GlobalPos.of(source);
        $targets.forEach(globalPos::teleport);
        return 1;
    }
}

