/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_warmup;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.manager.Managers;
import io.github.sakurawald.fuji.core.structure.Tag;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.command_warmup.config.model.CommandWarmupConfigModel;
import io.github.sakurawald.fuji.module.initializer.command_warmup.structure.CommandWarmupNode;
import io.github.sakurawald.fuji.module.initializer.command_warmup.structure.CommandWarmupTicket;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Document(id=1751826885335L, value="This module allows you to define a `cooldown` before command execution.\n")
@ColorBoxes(value={@ColorBox(id=1751870580067L, color=ColorBox.ColorBlockTypes.NOTE, value="The `command_warmup` module is `before` the command execution.\nThe `command_cooldown` module is `after` the command execution.\n"), @ColorBox(id=1751974763151L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Set up the warmup for all commands.\nRegex: `.+`\n\nThe `.` character in regex means `match any character`.\nThe `+` character in regex means `a quantifier, one or more times`.\n"), @ColorBox(id=1751974917420L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Set up the warmup for all commands, but specify a special setup for `/back` command.\nYou can just write the `config section` for `/back` command `at the top` of rules.\nThe `rules` are `matched` from up to down, and `the first matched rule` will be used.\nSo, you can just write the `special rule` at the top of other rules.\n"), @ColorBox(id=1751975050645L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Set up the warmup for all command, except the `/back` command.\nRegex: `(?!back).+`\n\nThe regex use the `negative lookahead`, to exclude the string that `starts with back`.\n"), @ColorBox(id=1751975123435L, color=ColorBox.ColorBlockTypes.EXAMPLE, value="\u25c9 Share the same warmup setup for multiple commands.\nRegex: `(back)|(heal)|(feed)`\n\nYou can use the `alternative character |` in `regex`.\n")})
public class CommandWarmupInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<CommandWarmupConfigModel> config = new ObjectConfigurationHandler<CommandWarmupConfigModel>("config.json", CommandWarmupConfigModel.class);

    public static void processCommandWarmup(class_3222 player, String commandString, CallbackInfo ci) {
        LogUtil.debug("Process command warmup: player = {}, command = {}", PlayerHelper.getPlayerName((class_1657)player), commandString);
        CommandWarmupConfigModel config = CommandWarmupInitializer.config.model();
        for (CommandWarmupNode entry : config.entries) {
            if (Tag.hasAnyTagPermission((class_1657)player, "command_warmup.bypass", entry.getTag().getTags()) || !commandString.matches(entry.getCommand().getRegex())) continue;
            if (!CommandHelper.canUseThisCommand(player, commandString)) break;
            Managers.getBossBarManager().addTicket(CommandWarmupTicket.make(player, commandString, entry));
            if (config.warn_for_move) {
                TextHelper.sendTextByKey(player, "command_warmup.warn_for_move", entry.getInterruptible().getInterruptDistance());
            }
            ci.cancel();
            break;
        }
    }
}

