/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.core;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.config.Configs;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.event.impl.ServerLifecycleEvents;
import io.github.sakurawald.fuji.core.manager.impl.module.ModuleManager;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import java.util.ArrayList;
import java.util.List;

@ColorBoxes(value={@ColorBox(id=1751870436910L, color=ColorBox.ColorBlockTypes.TIPS, value="\u25c9 How to use fuji?\n\nAll `modules` are `disabled` by default.\nYou can only enable the `interested modules`.\nModify the `config/fuji/config.json` file to `enable` a module.\nAfter that, `re-start` the server, to apply the `module enable status`.\n"), @ColorBox(id=1751870440489L, color=ColorBox.ColorBlockTypes.NOTE, value="\u25c9 Does fuji support the `hot reload`?\n\nYes, fuji does support to `hot reload` the `files` from a `enabled module`.\nTo do that, just issue `/fuji reload`.\n\nHowever, you can't `enable` or `disable` a module when the server `is running`.\nThis is a design decision.\nFuji will `never load` a `disabled module` at all, for these considerations:\n1. For flexible, you can `disable any module` you don't like.\n2. If any other mods conflicts with `a module`, you can just `disable that module`.\n3. You only enable the `interested modules`, and there is no performance paying for `disabled module`.\n")})
public class CoreInitializer
extends ModuleInitializer {
    @Override
    protected void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> CoreInitializer.onServerStartSuccess());
    }

    public static void printUserGuide() {
        String userGuide = " \u001b[2;35m\u001b[1;35m\n [Fuji User Guide]\u001b[0m\u001b[2;35m\n It seems that this is the first time you use fuji mod.\n\n Here are some important points:\n - Fuji is designed to be fully-modular, that is to say, \u001b[2;34mall modules are disabled by default.\u001b[0m\u001b[2;35m\n - To enable a module: modify the `\u001b[2;34mconfig/fuji/config.json\u001b[0m\u001b[2;35m` file, and \u001b[2;34mre-start\u001b[0m\u001b[2;35m the server to apply the modification.\n     - To use `/tpa` command, enable the `tpa` module.\n     - To use placeholders provided by fuji, enable the `placeholder` module.\n     - To use echo commands like `/send-message`, `/send-broadcast` etc, enable the `echo` module.\n - To see the list of modules, and what functions they provides, read the `fuji manual` pdf file in \u001b[2;34mhttps://github.com/sakurawald/fuji/raw/dev/docs/release/fuji.pdf\u001b[0m\u001b[2;35m\n - To discover new things, use `/fuji inspect` command.\n - Anything unclear, open an issue in \u001b[2;34mhttps://github.com/sakurawald/fuji/issues\u001b[0m\u001b[2;35m\u001b[0m\u001b[2;35m\n - Now, issue `\u001b[2;34m/fuji\u001b[0m\u001b[2;35m` to get started!\n";
        LogUtil.info(userGuide, new Object[0]);
    }

    private static void tryPrintUserGuide(List<String> enabledModuleList) {
        if (Configs.MAIN_CONTROL_CONFIG.model().core.debug.print_user_guide_in_console || enabledModuleList.size() == 1) {
            CoreInitializer.printUserGuide();
        }
    }

    private static void onServerStartSuccess() {
        ArrayList<String> enabledModuleList = new ArrayList<String>();
        ModuleManager.MODULE_ENABLE_STATUS.forEach((module, enable) -> {
            if (enable.booleanValue()) {
                enabledModuleList.add(ModuleManager.joinModulePath(module));
            }
        });
        enabledModuleList.sort(String::compareTo);
        LogUtil.info("Enabled {}/{} modules -> {}", enabledModuleList.size(), ModuleManager.MODULE_ENABLE_STATUS.size(), enabledModuleList);
        CoreInitializer.tryPrintUserGuide(enabledModuleList);
    }
}

