/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.deathlog.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.NbtHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.gui.impl.gui.PagedGui;
import io.github.sakurawald.fuji.module.initializer.deathlog.DeathLogInitializer;
import io.github.sakurawald.fuji.module.initializer.deathlog.gui.DeathNodeListGui;
import io.github.sakurawald.fuji.module.initializer.deathlog.structure.DeathNode;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeathDataListGui
extends PagedGui<String> {
    public DeathDataListGui(class_3222 player, @NotNull List<String> entities, int pageIndex) {
        super(null, player, TextHelper.getTextByKey(player, "deathlog.death_data.list.gui.title", new Object[0]), entities, pageIndex);
    }

    public static boolean hasDeathData(class_3222 player, class_2487 root, String deadPlayerName) {
        if (root == null || root.method_33133()) {
            TextHelper.sendTextByKey(player, "deathlog.death_data.empty", deadPlayerName);
            return false;
        }
        return true;
    }

    @Override
    protected PagedGui<String> make(@Nullable SimpleGui parent, class_3222 player, class_2561 title, @NotNull List<String> entities, int pageIndex) {
        return new DeathDataListGui(player, entities, 0);
    }

    @Override
    protected GuiElementInterface toGuiElement(String entity) {
        GuiElementBuilder builder = new GuiElementBuilder();
        builder.setItem(class_1802.field_8398).setName((class_2561)class_2561.method_43470((String)entity)).setCallback(() -> NbtHelper.Storage.withNbtFile(DeathLogInitializer.getDeathDataPath(entity), root -> {
            if (!DeathDataListGui.hasDeathData(this.getPlayer(), root, entity)) {
                this.close();
                return;
            }
            class_2499 deathNodeList = NbtHelper.Walker.withNbtElement(root, "Deaths", new class_2499());
            List<DeathNode> entries = deathNodeList.stream().map(it -> DeathNode.fromNbt((class_2487)it)).collect(Collectors.toList());
            Collections.reverse(entries);
            new DeathNodeListGui(this.getBackendGui(), this.getPlayer(), entity, entries, 0).open();
        }));
        return builder.build();
    }
}

