/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.deathlog.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.gui.impl.gui.PagedGui;
import io.github.sakurawald.fuji.module.initializer.deathlog.gui.DeathNodeDisplayGuiFactory;
import io.github.sakurawald.fuji.module.initializer.deathlog.structure.DeathNode;
import java.util.List;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeathNodeListGui
extends PagedGui<DeathNode> {
    private final String deadPlayerName;

    public DeathNodeListGui(@Nullable SimpleGui parent, class_3222 player, String deadPlayerName, @NotNull List<DeathNode> entities, int pageIndex) {
        super(parent, player, TextHelper.getTextByKey(player, "deathlog.death_node.list.gui.title", deadPlayerName), entities, pageIndex);
        this.deadPlayerName = deadPlayerName;
    }

    @Override
    protected PagedGui<DeathNode> make(@Nullable SimpleGui parent, class_3222 player, class_2561 title, @NotNull List<DeathNode> entities, int pageIndex) {
        return new DeathNodeListGui(parent, player, this.deadPlayerName, entities, pageIndex);
    }

    @Override
    protected GuiElementInterface toGuiElement(DeathNode entity) {
        return ((GuiElementBuilder)new GuiElementBuilder().setItem(class_1802.field_8106).setName(class_2561.method_30163((String)entity.time)).setLore(entity.getLore(this.getPlayer())).setCallback(() -> this.openDeathNodeDisplayGui(entity))).build();
    }

    private void openDeathNodeDisplayGui(DeathNode entity) {
        new DeathNodeDisplayGuiFactory(this.getBackendGui(), entity).build(this.getPlayer()).open();
    }

    @Override
    protected boolean filterEntity(DeathNode entity, String keyword) {
        return entity.dimension.contains(keyword) || entity.time.contains(keyword) || entity.reason.toLowerCase().contains(keyword.toLowerCase()) || entity.main.toString().toLowerCase().contains(keyword.toLowerCase()) || entity.armor.toString().toLowerCase().contains(keyword.toLowerCase()) || entity.offhand.toString().toLowerCase().contains(keyword.toLowerCase());
    }
}

