/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.economy;

import com.mojang.authlib.GameProfile;
import eu.pb4.common.economy.api.EconomyAccount;
import eu.pb4.common.economy.api.EconomyProvider;
import eu.pb4.common.economy.api.EconomyTransaction;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.OfflineGameProfile;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.economy.command.argument.wrapper.CurrencyId;
import io.github.sakurawald.fuji.module.initializer.economy.config.model.EconomyConfigModel;
import io.github.sakurawald.fuji.module.initializer.economy.config.model.EconomyDataModel;
import io.github.sakurawald.fuji.module.initializer.economy.gui.BalanceTopGui;
import io.github.sakurawald.fuji.module.initializer.economy.service.EconomyService;
import io.github.sakurawald.fuji.module.initializer.economy.structure.CustomEconomyProvider;
import java.util.Collection;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

@Document(id=1751826915564L, value="This module allows you to enable the `economy gameplay`.\nAnd define your `custom currency types`.\n\nOne `player` can have many `accounts`.\nOne `account` holds one type of `currency`.\n")
@ColorBoxes(value={@ColorBox(id=1751870587446L, color=ColorBox.ColorBlockTypes.TIPS, value="You can use this module with `Universal Shops` mod.\n"), @ColorBox(id=1751870591800L, color=ColorBox.ColorBlockTypes.TIPS, value="You can use `command_bundle` module.\nTo create a `/balance` command, to wrap the `/economy account %player:name% fuji:gold` command.\n")})
public class EconomyInitializer
extends ModuleInitializer {
    public static BaseConfigurationHandler<EconomyConfigModel> config = new ObjectConfigurationHandler<EconomyConfigModel>("config.json", EconomyConfigModel.class);
    public static BaseConfigurationHandler<EconomyDataModel> data = new ObjectConfigurationHandler<EconomyDataModel>("economy-data.json", EconomyDataModel.class);

    @Document(id=1751826918349L, value="List all installed `economy providers`, and what `economy currencies` they provided.\n")
    @CommandNode(value="economy providers")
    @CommandRequirement(level=4)
    private static int $providers(@CommandSource class_2168 source) {
        Collection<EconomyProvider> providers = EconomyService.getProviders();
        source.method_45068((class_2561)class_2561.method_43470((String)"There are %d providers installed in this server.".formatted(providers.size())));
        providers.forEach(provider -> {
            MinecraftServer server = ServerHelper.getServer();
            TextHelper.sendTextByKey(source, "line.separator", new Object[0]);
            TextHelper.sendTextByKey(source, "economy.provider.id", provider.id());
            TextHelper.sendTextByKey(source, "economy.provider.name", TextHelper.Operators.visitString(provider.name()));
            TextHelper.sendTextByKey(source, "economy.provider.icon", provider.icon().method_7909());
            Collection currencies = provider.getCurrencies(server);
            currencies.forEach(currency -> {
                TextHelper.sendTextByKey(source, "economy.currency.id", currency.id());
                TextHelper.sendTextByKey(source, "economy.currency.name", TextHelper.Operators.visitString(currency.name()));
                TextHelper.sendTextByKey(source, "economy.currency.icon", currency.icon().method_7909());
                source.method_45068(TextHelper.TEXT_EMPTY);
            });
        });
        return 1;
    }

    @Document(id=1751826920505L, value="List all `accounts` owned by the `player`.\n")
    @CommandNode(value="economy accounts")
    @CommandRequirement(level=4)
    private static int $accounts(@CommandSource class_2168 source, OfflineGameProfile player) {
        Collection<EconomyAccount> accounts = EconomyService.getUserAccounts((GameProfile)player.getValue());
        accounts.forEach(account -> EconomyInitializer.printEconomyAccountInfo(source, account));
        return 1;
    }

    private static void printEconomyAccountInfo(class_2168 source, EconomyAccount account) {
        TextHelper.sendTextByKey(source, "economy.account.name", TextHelper.Operators.visitString(account.name()));
        TextHelper.sendTextByKey(source, "economy.account.formatted_balance", TextHelper.Operators.visitString(account.formattedBalance()));
        source.method_45068(TextHelper.TEXT_EMPTY);
    }

    @Document(id=1751826922680L, value="Get the `player`'s `account` for `currency ID`.\n")
    @CommandNode(value="economy account")
    @CommandRequirement(level=4)
    private static int $account(@CommandSource class_2168 source, OfflineGameProfile player, CurrencyId currencyId) {
        class_2960 $currencyId = (class_2960)currencyId.getValue();
        EconomyAccount economyAccount = EconomyService.getUserAccount((GameProfile)player.getValue(), $currencyId);
        EconomyInitializer.printEconomyAccountInfo(source, economyAccount);
        return 1;
    }

    @Document(id=1751826925194L, value="Query your economy `accounts`.\n")
    @CommandNode(value="economy balance")
    private static int $balance(@CommandSource class_3222 player) {
        OfflineGameProfile offlineGameProfile = new OfflineGameProfile(player.method_7334());
        EconomyInitializer.$accounts(player.method_5671(), offlineGameProfile);
        return 1;
    }

    @Document(id=1751826927389L, value="List the top players of specified currency.\n")
    @CommandNode(value="economy balance-top")
    private static int $balanceTop(@CommandSource class_3222 player, CurrencyId currencyId) {
        BalanceTopGui.make(player, (class_2960)currencyId.getValue()).open();
        return 1;
    }

    @Document(id=1751826931165L, value="Give `amount` to the player's `account` for `specified currency`.")
    @CommandNode(value="economy give")
    @CommandRequirement(level=4)
    private static int $give(@CommandSource class_2168 source, OfflineGameProfile player, CurrencyId currencyId, double amount) {
        class_2960 $currencyId = (class_2960)currencyId.getValue();
        EconomyAccount economyAccount = EconomyService.getUserAccount((GameProfile)player.getValue(), $currencyId);
        long deltaValue = (long)(amount * 100.0);
        EconomyTransaction economyTransaction = economyAccount.increaseBalance(deltaValue);
        source.method_45068(economyTransaction.message());
        return 1;
    }

    @Document(id=1751826933066L, value="Take `amount` from the player's `account` for `specified currency`.")
    @CommandNode(value="economy take")
    @CommandRequirement(level=4)
    private static int $take(@CommandSource class_2168 source, OfflineGameProfile player, CurrencyId currencyId, double amount) {
        class_2960 $currencyId = (class_2960)currencyId.getValue();
        EconomyAccount economyAccount = EconomyService.getUserAccount((GameProfile)player.getValue(), $currencyId);
        long deltaValue = (long)(amount * 100.0);
        EconomyTransaction economyTransaction = economyAccount.decreaseBalance(deltaValue);
        source.method_45068(economyTransaction.message());
        return 1;
    }

    @Document(id=1751826934778L, value="Pay specified `amount` of `currency` to another player's account.")
    @CommandNode(value="economy pay")
    private static int $pay(@CommandSource class_3222 source, OfflineGameProfile player, CurrencyId currencyId, double amount) {
        EconomyService.transferCurrency(source, player, (class_2960)currencyId.getValue(), amount);
        return 1;
    }

    @Document(id=1751826937120L, value="Has the specified amount of currency?")
    @CommandNode(value="has-currency?")
    @CommandRequirement(level=4)
    private static int $hasCurrency(@CommandSource class_2168 source, OfflineGameProfile player, CurrencyId currencyId, double amount) {
        class_2960 $currencyId = (class_2960)currencyId.getValue();
        EconomyAccount economyAccount = EconomyService.getUserAccount((GameProfile)player.getValue(), $currencyId);
        long finalValue = (long)(amount * 100.0);
        boolean value = economyAccount.balance() >= finalValue;
        return CommandHelper.Return.returnBoolean(source, value);
    }

    @Document(id=1751826939422L, value="Set the `amount` of the player's `account` for `specified currency`.")
    @CommandNode(value="economy set")
    @CommandRequirement(level=4)
    private static int $set(@CommandSource class_2168 source, OfflineGameProfile player, CurrencyId currencyId, double amount) {
        class_2960 $currencyId = (class_2960)currencyId.getValue();
        EconomyAccount economyAccount = EconomyService.getUserAccount((GameProfile)player.getValue(), $currencyId);
        long finalValue = (long)(amount * 100.0);
        economyAccount.setBalance(finalValue);
        TextHelper.sendTextByKey(source, "operation.success", new Object[0]);
        return 1;
    }

    @Document(id=1751826942040L, value="Clear the `amount` of the player's `account` for `specified currency`.")
    @CommandNode(value="economy clear")
    @CommandRequirement(level=4)
    private static int $clear(@CommandSource class_2168 source, OfflineGameProfile player, CurrencyId currencyId) {
        EconomyInitializer.$set(source, player, currencyId, 0.0);
        return 1;
    }

    static {
        CustomEconomyProvider.initializeCustomEconomyProvider();
    }
}

