/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.economy.gui;

import com.mojang.authlib.GameProfile;
import eu.pb4.common.economy.api.EconomyAccount;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.gui.impl.gui.PagedGui;
import io.github.sakurawald.fuji.module.initializer.economy.service.EconomyService;
import io.github.sakurawald.fuji.module.initializer.economy.structure.GameProfileAndEconomyAccount;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BalanceTopGui
extends PagedGui<GameProfileAndEconomyAccount> {
    private final class_2960 currencyId;

    public BalanceTopGui(@Nullable SimpleGui parent, @NotNull class_3222 player, class_2960 currencyId, @NotNull List<GameProfileAndEconomyAccount> entities, int pageIndex) {
        super(parent, player, TextHelper.getTextByKey(player, "economy.balance.top.gui.title", currencyId), entities, pageIndex);
        this.currencyId = currencyId;
    }

    @Override
    protected PagedGui<GameProfileAndEconomyAccount> make(@Nullable SimpleGui parent, class_3222 player, class_2561 title, @NotNull List<GameProfileAndEconomyAccount> entities, int pageIndex) {
        return new BalanceTopGui(parent, player, this.currencyId, entities, pageIndex);
    }

    public static BalanceTopGui make(class_3222 player, class_2960 currencyId) {
        List<GameProfileAndEconomyAccount> entities = ServerHelper.getOfflineGameProfiles().stream().map(gameProfile -> {
            EconomyAccount economyAccount = EconomyService.getUserAccount(gameProfile, currencyId);
            return new GameProfileAndEconomyAccount((GameProfile)gameProfile, economyAccount);
        }).sorted(Comparator.comparing(GameProfileAndEconomyAccount::getEconomyBalance).reversed()).toList();
        return new BalanceTopGui(null, player, currencyId, entities, 0);
    }

    @Override
    protected GuiElementInterface toGuiElement(GameProfileAndEconomyAccount entity) {
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        lore.add(TextHelper.getTextByKey(this.getPlayer(), "economy.balance", TextHelper.Operators.visitString(entity.economyAccount.formattedBalance())));
        GuiElementBuilder builder = GuiHelper.makeLuckyBlockSkull().setName((class_2561)class_2561.method_43470((String)entity.gameProfile.getName())).setLore(lore);
        return builder.build();
    }

    @Override
    protected void drawPagedGui() {
        super.drawPagedGui();
        GuiHelper.fetchHeads(this, () -> this.draw());
    }
}

